/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.function.Predicate;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;

class PackageNameSelectorResolver
extends DiscoverySelectorResolver<PackageSelector> {
    private final Predicate<String> classNamePredicate;

    PackageNameSelectorResolver(Predicate<String> classNamePredicate) {
        super(PackageSelector.class);
        this.classNamePredicate = classNamePredicate;
    }

    @Override
    void resolve(PackageSelector selector, TestClassCollector collector) {
        ReflectionUtils.findAllClassesInPackage(selector.getPackageName(), classTester, this.classNamePredicate).forEach(collector::addCompletely);
    }
}

