/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Map;
import java.util.Optional;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.ConfigurationParameters;

class LauncherConfigurationParameters
implements ConfigurationParameters {
    private final Map<String, String> configurationParameters;

    LauncherConfigurationParameters(Map<String, String> configurationParameters) {
        Preconditions.notNull(configurationParameters, "configuration parameters must not be null");
        this.configurationParameters = configurationParameters;
    }

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.getProperty(key));
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        String property = this.getProperty(key);
        if (property != null) {
            return Optional.of(Boolean.parseBoolean(property));
        }
        return Optional.empty();
    }

    @Override
    public int size() {
        return this.configurationParameters.size();
    }

    private String getProperty(String key) {
        Preconditions.notBlank(key, "key must not be null or blank");
        String value = this.configurationParameters.get(key);
        if (value == null) {
            try {
                value = System.getProperty(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        this.configurationParameters.forEach(builder::append);
        return builder.toString();
    }
}

