/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.core.LauncherConfigurationParameters;

final class DefaultDiscoveryRequest
implements LauncherDiscoveryRequest {
    private final List<DiscoverySelector> selectors;
    private final List<EngineFilter> engineFilters;
    private final List<DiscoveryFilter<?>> discoveryFilters;
    private final List<PostDiscoveryFilter> postDiscoveryFilters;
    private final LauncherConfigurationParameters configurationParameters;

    DefaultDiscoveryRequest(List<DiscoverySelector> selectors, List<EngineFilter> engineFilters, List<DiscoveryFilter<?>> discoveryFilters, List<PostDiscoveryFilter> postDiscoveryFilters, LauncherConfigurationParameters configurationParameters) {
        this.selectors = selectors;
        this.engineFilters = engineFilters;
        this.discoveryFilters = discoveryFilters;
        this.postDiscoveryFilters = postDiscoveryFilters;
        this.configurationParameters = configurationParameters;
    }

    @Override
    public <T extends DiscoverySelector> List<T> getSelectorsByType(Class<T> selectorType) {
        Preconditions.notNull(selectorType, "selectorType must not be null");
        return this.selectors.stream().filter(selectorType::isInstance).map(selectorType::cast).collect(Collectors.toList());
    }

    @Override
    public List<EngineFilter> getEngineFilters() {
        return Collections.unmodifiableList(this.engineFilters);
    }

    @Override
    public <T extends DiscoveryFilter<?>> List<T> getDiscoveryFiltersByType(Class<T> filterType) {
        Preconditions.notNull(filterType, "filterType must not be null");
        return this.discoveryFilters.stream().filter(filterType::isInstance).map(filterType::cast).collect(Collectors.toList());
    }

    @Override
    public List<PostDiscoveryFilter> getPostDiscoveryFilters() {
        return Collections.unmodifiableList(this.postDiscoveryFilters);
    }

    @Override
    public ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }
}

