/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.extension.RepeatedTestDisplayNameFormatter;
import org.junit.jupiter.engine.extension.RepeatedTestInvocationContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

class RepeatedTestExtension
implements TestTemplateInvocationContextProvider {
    private static final Logger logger = Logger.getLogger(RepeatedTestExtension.class.getName());

    RepeatedTestExtension() {
    }

    @Override
    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationUtils.isAnnotated(context.getTestMethod(), RepeatedTest.class);
    }

    @Override
    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Method testMethod = Preconditions.notNull(context.getTestMethod().orElse(null), "test method must not be null");
        String displayName = context.getDisplayName();
        RepeatedTest repeatedTest = AnnotationUtils.findAnnotation(testMethod, RepeatedTest.class).get();
        int totalRepetitions = this.totalRepetitions(repeatedTest, testMethod);
        RepeatedTestDisplayNameFormatter formatter = this.displayNameFormatter(repeatedTest, testMethod, displayName);
        return IntStream.rangeClosed(1, totalRepetitions).mapToObj(repetition -> new RepeatedTestInvocationContext(repetition, totalRepetitions, formatter));
    }

    private int totalRepetitions(RepeatedTest repeatedTest, Method method) {
        int repetitions = repeatedTest.value();
        if (repetitions < 1) {
            String message = "Configuration error: @RepeatedTest on method [%s] must be declared with a positive 'value'. Defaulting to 1 repetition.";
            logger.warning(String.format(message, method));
            repetitions = 1;
        }
        return repetitions;
    }

    private RepeatedTestDisplayNameFormatter displayNameFormatter(RepeatedTest repeatedTest, Method method, String displayName) {
        String pattern = repeatedTest.name().trim();
        if (StringUtils.isBlank(pattern)) {
            logger.warning(String.format("Configuration error: @RepeatedTest on method [%s] must be declared with a non-empty name.", method));
            pattern = AnnotationUtils.getDefaultValue(repeatedTest, "name", String.class).get();
        }
        return new RepeatedTestDisplayNameFormatter(pattern, displayName);
    }
}

