/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
class IsTestableMethod
implements Predicate<Method> {
    private final Class<? extends Annotation> annotationType;

    IsTestableMethod(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public boolean test(Method candidate) {
        if (ReflectionUtils.isStatic(candidate)) {
            return false;
        }
        if (ReflectionUtils.isPrivate(candidate)) {
            return false;
        }
        if (ReflectionUtils.isAbstract(candidate)) {
            return false;
        }
        return AnnotationUtils.isAnnotated(candidate, this.annotationType);
    }
}

