/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.util.function.Predicate;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.engine.discovery.predicates.IsInnerClass;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.AnnotationUtils;

@API(value=API.Usage.Internal)
public class IsNestedTestClass
implements Predicate<Class<?>> {
    private static final IsInnerClass isInnerClass = new IsInnerClass();

    @Override
    public boolean test(Class<?> candidate) {
        if (!isInnerClass.test(candidate)) {
            return false;
        }
        return AnnotationUtils.isAnnotated(candidate, Nested.class);
    }
}

