/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.MethodTestDescriptor;
import org.junit.jupiter.engine.execution.ThrowableCollector;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.EngineExecutionListener;

@API(value=API.Usage.Internal)
public final class MethodExtensionContext
extends AbstractExtensionContext<MethodTestDescriptor> {
    private final Object testInstance;
    private final ThrowableCollector throwableCollector;

    public MethodExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, MethodTestDescriptor testDescriptor, Object testInstance, ThrowableCollector throwableCollector) {
        super(parent, engineExecutionListener, testDescriptor);
        this.testInstance = testInstance;
        this.throwableCollector = throwableCollector;
    }

    @Override
    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((MethodTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Class<?>> getTestClass() {
        return Optional.of(((MethodTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    @Override
    public Optional<Method> getTestMethod() {
        return Optional.of(((MethodTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Object> getTestInstance() {
        return Optional.of(this.testInstance);
    }

    @Override
    public Optional<Throwable> getExecutionException() {
        return Optional.ofNullable(this.throwableCollector.getThrowable());
    }
}

