/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

final class LifecycleMethodUtils {
    private LifecycleMethodUtils() {
    }

    static List<Method> findBeforeAllMethods(Class<?> testClass, boolean requireStatic) {
        List<Method> methods = AnnotationUtils.findAnnotatedMethods(testClass, BeforeAll.class, ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
        if (requireStatic) {
            methods.forEach(method -> LifecycleMethodUtils.assertStatic(BeforeAll.class, method));
        }
        return methods;
    }

    static List<Method> findAfterAllMethods(Class<?> testClass, boolean requireStatic) {
        List<Method> methods = AnnotationUtils.findAnnotatedMethods(testClass, AfterAll.class, ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
        if (requireStatic) {
            methods.forEach(method -> LifecycleMethodUtils.assertStatic(AfterAll.class, method));
        }
        return methods;
    }

    static List<Method> findBeforeEachMethods(Class<?> testClass) {
        List<Method> methods = AnnotationUtils.findAnnotatedMethods(testClass, BeforeEach.class, ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
        methods.forEach(method -> LifecycleMethodUtils.assertNonStatic(BeforeEach.class, method));
        return methods;
    }

    static List<Method> findAfterEachMethods(Class<?> testClass) {
        List<Method> methods = AnnotationUtils.findAnnotatedMethods(testClass, AfterEach.class, ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
        methods.forEach(method -> LifecycleMethodUtils.assertNonStatic(AfterEach.class, method));
        return methods;
    }

    private static void assertStatic(Class<? extends Annotation> annotationType, Method method) {
        if (!ReflectionUtils.isStatic(method)) {
            throw new JUnitException(String.format("@%s method '%s' must be static unless the test class is annotated with @TestInstance(Lifecycle.PER_CLASS).", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertNonStatic(Class<? extends Annotation> annotationType, Method method) {
        if (ReflectionUtils.isStatic(method)) {
            throw new JUnitException(String.format("@%s method '%s' must not be static.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }
}

