/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.function.Predicate;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;

class ClasspathRootSelectorResolver
extends DiscoverySelectorResolver<ClasspathRootSelector> {
    private final Predicate<String> classNamePredicate;

    ClasspathRootSelectorResolver(Predicate<String> classNamePredicate) {
        super(ClasspathRootSelector.class);
        this.classNamePredicate = classNamePredicate;
    }

    @Override
    void resolve(ClasspathRootSelector selector, TestClassCollector collector) {
        ReflectionUtils.findAllClassesInClasspathRoot(selector.getClasspathRoot(), classTester, this.classNamePredicate).forEach(collector::addCompletely);
    }
}

