/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.TestIdentifier;

@API(value=API.Usage.Experimental)
public final class TestPlan {
    private final Set<TestIdentifier> roots = Collections.synchronizedSet(new LinkedHashSet(4));
    private final Map<String, Set<TestIdentifier>> children = new ConcurrentHashMap<String, Set<TestIdentifier>>(32);
    private final Map<String, TestIdentifier> allIdentifiers = new ConcurrentHashMap<String, TestIdentifier>(32);

    @API(value=API.Usage.Internal)
    public static TestPlan from(Collection<TestDescriptor> engineDescriptors) {
        Preconditions.notNull(engineDescriptors, "Cannot create TestPlan from a null collection of TestDescriptors");
        TestPlan testPlan = new TestPlan();
        TestDescriptor.Visitor visitor = descriptor -> testPlan.add(TestIdentifier.from(descriptor));
        engineDescriptors.forEach(engineDescriptor -> engineDescriptor.accept(visitor));
        return testPlan;
    }

    private TestPlan() {
    }

    public void add(TestIdentifier testIdentifier) {
        Preconditions.notNull(testIdentifier, "testIdentifier must not be null");
        this.allIdentifiers.put(testIdentifier.getUniqueId(), testIdentifier);
        if (testIdentifier.getParentId().isPresent()) {
            String parentId = testIdentifier.getParentId().get();
            Set directChildren = this.children.computeIfAbsent(parentId, key -> Collections.synchronizedSet(new LinkedHashSet(16)));
            directChildren.add(testIdentifier);
        } else {
            this.roots.add(testIdentifier);
        }
    }

    public Set<TestIdentifier> getRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    public Optional<TestIdentifier> getParent(TestIdentifier child) {
        Preconditions.notNull(child, "child must not be null");
        Optional<String> optionalParentId = child.getParentId();
        if (optionalParentId.isPresent()) {
            return Optional.of(this.getTestIdentifier(optionalParentId.get()));
        }
        return Optional.empty();
    }

    public Set<TestIdentifier> getChildren(TestIdentifier parent) {
        Preconditions.notNull(parent, "parent must not be null");
        return this.getChildren(parent.getUniqueId());
    }

    public Set<TestIdentifier> getChildren(String parentId) {
        Preconditions.notBlank(parentId, "parent ID must not be null or blank");
        return this.children.containsKey(parentId) ? Collections.unmodifiableSet(this.children.get(parentId)) : Collections.emptySet();
    }

    public TestIdentifier getTestIdentifier(String uniqueId) throws PreconditionViolationException {
        Preconditions.notBlank(uniqueId, "unique ID must not be null or blank");
        Preconditions.condition(this.allIdentifiers.containsKey(uniqueId), () -> "No TestIdentifier with unique ID [" + uniqueId + "] has been added to this TestPlan.");
        return this.allIdentifiers.get(uniqueId);
    }

    public long countTestIdentifiers(Predicate<? super TestIdentifier> predicate) {
        Preconditions.notNull(predicate, "Predicate must not be null");
        return this.allIdentifiers.values().stream().filter(predicate).count();
    }

    public Set<TestIdentifier> getDescendants(TestIdentifier parent) {
        Preconditions.notNull(parent, "parent must not be null");
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>(16);
        Set<TestIdentifier> children = this.getChildren(parent);
        result.addAll(children);
        for (TestIdentifier child : children) {
            result.addAll(this.getDescendants(child));
        }
        return Collections.unmodifiableSet(result);
    }
}

