/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.util.Objects;
import java.util.Optional;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.FilePosition;

@API(value=API.Usage.Experimental)
public class ClasspathResourceSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final String classpathResourceName;
    private final FilePosition filePosition;

    public ClasspathResourceSource(String classpathResourceName) {
        this(classpathResourceName, null);
    }

    public ClasspathResourceSource(String classpathResourceName, FilePosition filePosition) {
        Preconditions.notBlank(classpathResourceName, "Classpath resource name must not be null or blank");
        boolean startsWithSlash = classpathResourceName.startsWith("/");
        this.classpathResourceName = startsWithSlash ? classpathResourceName.substring(1) : classpathResourceName;
        this.filePosition = filePosition;
    }

    public String getClasspathResourceName() {
        return this.classpathResourceName;
    }

    public final Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.filePosition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathResourceSource that = (ClasspathResourceSource)o;
        return Objects.equals(this.classpathResourceName, that.classpathResourceName) && Objects.equals(this.filePosition, that.filePosition);
    }

    public int hashCode() {
        return Objects.hash(this.classpathResourceName, this.filePosition);
    }

    public String toString() {
        return new ToStringBuilder(this).append("classpathResourceName", this.classpathResourceName).append("filePosition", this.filePosition).toString();
    }
}

