/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(value=API.Usage.Experimental)
public interface TestDescriptor {
    public UniqueId getUniqueId();

    public String getDisplayName();

    default public String getLegacyReportingName() {
        return this.getDisplayName();
    }

    public Set<TestTag> getTags();

    public Optional<TestSource> getSource();

    public Optional<TestDescriptor> getParent();

    public void setParent(TestDescriptor var1);

    public Set<? extends TestDescriptor> getChildren();

    default public Set<? extends TestDescriptor> getDescendants() {
        LinkedHashSet<TestDescriptor> descendants = new LinkedHashSet<TestDescriptor>();
        descendants.addAll(this.getChildren());
        for (TestDescriptor testDescriptor : this.getChildren()) {
            descendants.addAll(testDescriptor.getDescendants());
        }
        return Collections.unmodifiableSet(descendants);
    }

    public void addChild(TestDescriptor var1);

    public void removeChild(TestDescriptor var1);

    public void removeFromHierarchy();

    default public boolean isRoot() {
        return !this.getParent().isPresent();
    }

    public Type getType();

    default public boolean isContainer() {
        return this.getType().isContainer();
    }

    default public boolean isTest() {
        return this.getType().isTest();
    }

    default public boolean hasTests() {
        return this.isTest() || this.getChildren().stream().anyMatch(TestDescriptor::hasTests);
    }

    default public void prune() {
        if (this.isRoot() || this.hasTests()) {
            return;
        }
        this.removeFromHierarchy();
    }

    default public void pruneTree() {
        this.accept(TestDescriptor::prune);
    }

    public Optional<? extends TestDescriptor> findByUniqueId(UniqueId var1);

    default public void accept(Visitor visitor) {
        visitor.visit(this);
        new LinkedHashSet<TestDescriptor>(this.getChildren()).forEach(child -> child.accept(visitor));
    }

    public static enum Type {
        ENGINE,
        CONTAINER,
        TEST,
        CONTAINER_AND_TEST;


        public boolean isContainer() {
            return this == ENGINE || this == CONTAINER || this == CONTAINER_AND_TEST;
        }

        public boolean isTest() {
            return this == TEST || this == CONTAINER_AND_TEST;
        }
    }

    @FunctionalInterface
    public static interface Visitor {
        public void visit(TestDescriptor var1);
    }
}

