/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ObjectArrayArguments;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.Preconditions;

class EnumArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<EnumSource> {
    private Class<? extends Enum<?>> enumClass;
    private Set<String> names = Collections.emptySet();

    EnumArgumentsProvider() {
    }

    @Override
    public void accept(EnumSource enumSource) {
        this.enumClass = enumSource.value();
        if (enumSource.names().length > 0) {
            this.names = Arrays.stream(enumSource.names()).collect(Collectors.toSet());
            Preconditions.condition(this.names.size() == enumSource.names().length, () -> "Duplicate enum constant name(s) found in annotation: " + enumSource);
            Set allSet = Arrays.stream(this.enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
            Preconditions.condition(allSet.containsAll(this.names), () -> "Invalid enum constant name(s) found in annotation: " + enumSource + ". Valid names include: " + allSet);
        }
    }

    @Override
    public Stream<? extends Arguments> arguments(ContainerExtensionContext context) {
        return Arrays.stream(this.enumClass.getEnumConstants()).filter(this::select).map(xva$0 -> ObjectArrayArguments.create(xva$0));
    }

    private boolean select(Enum<?> constant) {
        return this.names == Collections.EMPTY_SET || this.names.contains(constant.name());
    }
}

