/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.com.univocity.parsers.conversions;

import org.junit.jupiter.params.com.univocity.parsers.conversions.Conversion;

public class TrimConversion
implements Conversion<String, String> {
    private final int length;

    public TrimConversion() {
        this.length = -1;
    }

    public TrimConversion(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Maximum trim length must be positive");
        }
        this.length = length;
    }

    @Override
    public String execute(String input) {
        if (input == null) {
            return null;
        }
        if (this.length != -1 && (input = input.trim()).length() > this.length) {
            return input.substring(0, this.length);
        }
        return input.trim();
    }

    @Override
    public String revert(String input) {
        return this.execute(input);
    }
}

