/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestInvocationContext;
import org.junit.jupiter.params.ParameterizedTestNameFormatter;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationInitializer;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestExtension
implements TestTemplateInvocationContextProvider {
    private static final Logger logger = Logger.getLogger(ParameterizedTestExtension.class.getName());

    ParameterizedTestExtension() {
    }

    @Override
    public boolean supports(ContainerExtensionContext context) {
        return AnnotationUtils.isAnnotated(context.getTestMethod(), ParameterizedTest.class);
    }

    @Override
    public Stream<TestTemplateInvocationContext> provide(ContainerExtensionContext context) {
        Method templateMethod = Preconditions.notNull(context.getTestMethod().orElse(null), "test method must not be null");
        ParameterizedTestNameFormatter formatter = this.createNameFormatter(templateMethod);
        return AnnotationUtils.findRepeatableAnnotations(templateMethod, ArgumentsSource.class).stream().map(ArgumentsSource::value).map(x$0 -> (ArgumentsProvider)ReflectionUtils.newInstance(x$0, new Object[0])).map(provider -> AnnotationInitializer.initialize(templateMethod, provider)).flatMap(provider -> ParameterizedTestExtension.arguments(provider, context)).map(Arguments::get).map(arguments -> new ParameterizedTestInvocationContext(formatter, (Object[])arguments));
    }

    private ParameterizedTestNameFormatter createNameFormatter(Method templateMethod) {
        ParameterizedTest parameterizedTest = AnnotationUtils.findAnnotation(templateMethod, ParameterizedTest.class).get();
        String name = parameterizedTest.name().trim();
        if (StringUtils.isBlank(name)) {
            logger.warning(String.format("Configuration error: @ParameterizedTest on method [%s] must be declared with a non-empty name.", templateMethod));
            name = AnnotationUtils.getDefaultValue(parameterizedTest, "name", String.class).get();
        }
        return new ParameterizedTestNameFormatter(name);
    }

    protected static Stream<? extends Arguments> arguments(ArgumentsProvider provider, ContainerExtensionContext context) {
        try {
            return provider.arguments(context);
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsUncheckedException(e);
        }
    }
}

