/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ContainerExecutionCondition;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionCondition;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.StringUtils;

class DisabledCondition
implements ContainerExecutionCondition,
TestExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled("@Disabled is not present");

    DisabledCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluate(ContainerExtensionContext context) {
        return this.evaluate(context.getElement());
    }

    @Override
    public ConditionEvaluationResult evaluate(TestExtensionContext context) {
        return this.evaluate(context.getElement());
    }

    private ConditionEvaluationResult evaluate(Optional<AnnotatedElement> element) {
        Optional<Disabled> disabled = AnnotationUtils.findAnnotation(element, Disabled.class);
        if (disabled.isPresent()) {
            String reason = disabled.map(Disabled::value).filter(StringUtils::isNotBlank).orElseGet(() -> element.get() + " is @Disabled");
            return ConditionEvaluationResult.disabled(reason);
        }
        return ENABLED;
    }
}

