/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateContainerExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;
import org.opentest4j.TestAbortedException;

@API(value=API.Usage.Internal)
public class TestTemplateTestDescriptor
extends MethodBasedTestDescriptor {
    public TestTemplateTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod) {
        super(uniqueId, testClass, templateMethod);
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public boolean hasTests() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) throws Exception {
        ExtensionRegistry registry = this.populateNewExtensionRegistryFromExtendWith(this.getTestMethod(), context.getExtensionRegistry());
        TestTemplateContainerExtensionContext testExtensionContext = new TestTemplateContainerExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this);
        return context.extend().withExtensionRegistry(registry).withExtensionContext(testExtensionContext).build();
    }

    @Override
    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) throws Exception {
        return this.shouldContainerBeSkipped(context);
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        ContainerExtensionContext containerExtensionContext = (ContainerExtensionContext)context.getExtensionContext();
        List<TestTemplateInvocationContextProvider> providers = this.validateProviders(containerExtensionContext, context.getExtensionRegistry());
        AtomicInteger invocationIndex = new AtomicInteger();
        providers.stream().flatMap(provider -> provider.provide(containerExtensionContext)).map(invocationContext -> this.createInvocationTestDescriptor((TestTemplateInvocationContext)invocationContext, invocationIndex.incrementAndGet())).forEach(invocationTestDescriptor -> this.execute(dynamicTestExecutor, (TestDescriptor)invocationTestDescriptor));
        this.validateWasAtLeastInvokedOnce(invocationIndex.get());
        return context;
    }

    private List<TestTemplateInvocationContextProvider> validateProviders(ContainerExtensionContext containerExtensionContext, ExtensionRegistry extensionRegistry) {
        List<TestTemplateInvocationContextProvider> providers = extensionRegistry.stream(TestTemplateInvocationContextProvider.class).filter(provider -> provider.supports(containerExtensionContext)).collect(Collectors.toList());
        Preconditions.notEmpty(providers, () -> String.format("You must register at least one %s that supports @TestTemplate method [%s]", TestTemplateInvocationContextProvider.class.getSimpleName(), this.getTestMethod()));
        return providers;
    }

    private TestDescriptor createInvocationTestDescriptor(TestTemplateInvocationContext invocationContext, int index) {
        UniqueId uniqueId = this.getUniqueId().append("test-template-invocation", "#" + index);
        return new TestTemplateInvocationTestDescriptor(uniqueId, this.getTestClass(), this.getTestMethod(), invocationContext, index);
    }

    private void execute(Node.DynamicTestExecutor dynamicTestExecutor, TestDescriptor testDescriptor) {
        this.addChild(testDescriptor);
        dynamicTestExecutor.execute(testDescriptor);
    }

    private void validateWasAtLeastInvokedOnce(int invocationIndex) {
        if (invocationIndex == 0) {
            throw new TestAbortedException("No supporting " + TestTemplateInvocationContextProvider.class.getSimpleName() + " provided an invocation context");
        }
    }
}

