/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.engine.descriptor.DynamicTestTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodTestDescriptor;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public class TestFactoryTestDescriptor
extends MethodTestDescriptor {
    public static final String DYNAMIC_TEST_SEGMENT_TYPE = "dynamic-test";
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();

    public TestFactoryTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod) {
        super(uniqueId, testClass, testMethod);
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public boolean hasTests() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    protected void invokeTestMethod(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        TestExtensionContext testExtensionContext = (TestExtensionContext)context.getExtensionContext();
        context.getThrowableCollector().execute(() -> {
            Object instance = testExtensionContext.getTestInstance();
            Object testFactoryMethodResult = executableInvoker.invoke(this.getTestMethod(), instance, (ExtensionContext)testExtensionContext, context.getExtensionRegistry());
            try (Stream<DynamicTest> dynamicTestStream = this.toDynamicTestStream(testFactoryMethodResult);){
                AtomicInteger index = new AtomicInteger();
                dynamicTestStream.forEach(dynamicTest -> this.registerAndExecute((DynamicTest)dynamicTest, index.incrementAndGet(), dynamicTestExecutor));
            }
            catch (ClassCastException ex) {
                throw this.invalidReturnTypeException(ex);
            }
        });
    }

    private Stream<DynamicTest> toDynamicTestStream(Object testFactoryMethodResult) {
        try {
            return CollectionUtils.toStream(testFactoryMethodResult);
        }
        catch (PreconditionViolationException ex) {
            throw this.invalidReturnTypeException(ex);
        }
    }

    private void registerAndExecute(DynamicTest dynamicTest, int index, Node.DynamicTestExecutor dynamicTestExecutor) {
        UniqueId uniqueId = this.getUniqueId().append(DYNAMIC_TEST_SEGMENT_TYPE, "#" + index);
        DynamicTestTestDescriptor descriptor = new DynamicTestTestDescriptor(uniqueId, dynamicTest, this.getSource().get());
        this.addChild(descriptor);
        dynamicTestExecutor.execute(descriptor);
    }

    private JUnitException invalidReturnTypeException(Throwable cause) {
        String message = String.format("@TestFactory method [%s] must return a Stream, Collection, Iterable, or Iterator of %s.", this.getTestMethod().toGenericString(), DynamicTest.class.getName());
        return new JUnitException(message, cause);
    }
}

