/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Set;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

abstract class MethodBasedTestDescriptor
extends JupiterTestDescriptor {
    private final Class<?> testClass;
    private final Method testMethod;

    MethodBasedTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod) {
        this(uniqueId, MethodBasedTestDescriptor.determineDisplayName((AnnotatedElement)Preconditions.notNull(testMethod, "Method must not be null"), MethodBasedTestDescriptor::generateDefaultDisplayName), testClass, testMethod);
    }

    MethodBasedTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod) {
        super(uniqueId, displayName);
        this.testClass = Preconditions.notNull(testClass, "Class must not be null");
        this.testMethod = Preconditions.notNull(testMethod, "Method must not be null");
        this.setSource(new MethodSource(testMethod));
    }

    @Override
    public final Set<TestTag> getTags() {
        Set<TestTag> methodTags = MethodBasedTestDescriptor.getTags(this.getTestMethod());
        this.getParent().ifPresent(parentDescriptor -> methodTags.addAll(parentDescriptor.getTags()));
        return methodTags;
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public String getLegacyReportingName() {
        return MethodBasedTestDescriptor.generateDefaultDisplayName(this.testMethod);
    }

    private static String generateDefaultDisplayName(Method testMethod) {
        return String.format("%s(%s)", testMethod.getName(), StringUtils.nullSafeToString(Class::getSimpleName, testMethod.getParameterTypes()));
    }
}

