/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.engine.execution.ConditionEvaluator;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public abstract class JupiterTestDescriptor
extends AbstractTestDescriptor
implements Node<JupiterEngineExecutionContext> {
    private static final Logger logger = Logger.getLogger(JupiterTestDescriptor.class.getName());
    private static final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();

    JupiterTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    protected static Set<TestTag> getTags(AnnotatedElement element) {
        return AnnotationUtils.findRepeatableAnnotations(element, Tag.class).stream().map(Tag::value).filter(StringUtils::isNotBlank).map(TestTag::create).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected static <E extends AnnotatedElement> String determineDisplayName(E element, Function<E, String> defaultDisplayNameGenerator) {
        Optional<DisplayName> displayNameAnnotation = AnnotationUtils.findAnnotation(element, DisplayName.class);
        if (displayNameAnnotation.isPresent()) {
            String displayName = displayNameAnnotation.get().value().trim();
            if (StringUtils.isBlank(displayName)) {
                logger.warning(String.format("Configuration error: @DisplayName on [%s] must be declared with a non-empty value.", element));
            } else {
                return displayName;
            }
        }
        return defaultDisplayNameGenerator.apply(element);
    }

    @Override
    public boolean isLeaf() {
        return !this.isContainer();
    }

    protected Node.SkipResult shouldContainerBeSkipped(JupiterEngineExecutionContext context) {
        ConditionEvaluationResult evaluationResult = conditionEvaluator.evaluateForContainer(context.getExtensionRegistry(), context.getConfigurationParameters(), (ContainerExtensionContext)context.getExtensionContext());
        return this.toSkipResult(evaluationResult);
    }

    protected Node.SkipResult shouldTestBeSkipped(JupiterEngineExecutionContext context) {
        ConditionEvaluationResult evaluationResult = conditionEvaluator.evaluateForTest(context.getExtensionRegistry(), context.getConfigurationParameters(), (TestExtensionContext)context.getExtensionContext());
        return this.toSkipResult(evaluationResult);
    }

    private Node.SkipResult toSkipResult(ConditionEvaluationResult evaluationResult) {
        if (evaluationResult.isDisabled()) {
            return Node.SkipResult.skip(evaluationResult.getReason().orElse("<unknown>"));
        }
        return Node.SkipResult.doNotSkip();
    }

    protected ExtensionRegistry populateNewExtensionRegistryFromExtendWith(AnnotatedElement annotatedElement, ExtensionRegistry existingExtensionRegistry) {
        List<Class<? extends Extension>> extensionTypes = AnnotationUtils.findRepeatableAnnotations(annotatedElement, ExtendWith.class).stream().map(ExtendWith::value).flatMap(Arrays::stream).collect(Collectors.toList());
        return ExtensionRegistry.createRegistryFrom(existingExtensionRegistry, extensionTypes);
    }

    protected void executeAndMaskThrowable(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable throwable) {
            ExceptionUtils.throwAsUncheckedException(throwable);
        }
    }
}

