/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(value=API.Usage.Experimental)
public class DynamicTest {
    private final String displayName;
    private final Executable executable;

    public static DynamicTest dynamicTest(String displayName, Executable executable) {
        return new DynamicTest(displayName, executable);
    }

    public static <T> Stream<DynamicTest> stream(Iterator<T> inputGenerator, Function<? super T, String> displayNameGenerator, ThrowingConsumer<? super T> testExecutor) {
        Preconditions.notNull(inputGenerator, "inputGenerator must not be null");
        Preconditions.notNull(displayNameGenerator, "displayNameGenerator must not be null");
        Preconditions.notNull(testExecutor, "testExecutor must not be null");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(inputGenerator, 16), false).map(input -> DynamicTest.dynamicTest((String)displayNameGenerator.apply(input), () -> testExecutor.accept(input)));
    }

    private DynamicTest(String displayName, Executable executable) {
        this.displayName = Preconditions.notBlank(displayName, "displayName must not be null or blank");
        this.executable = Preconditions.notNull(executable, "executable must not be null");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public String toString() {
        return new ToStringBuilder(this).append("displayName", this.displayName).toString();
    }
}

