/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Collections;
import java.util.List;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ExceptionUtils;

@API(value=API.Usage.Internal)
public final class BlacklistedExceptions {
    private static final List<Class<? extends Throwable>> blacklist = Collections.singletonList(OutOfMemoryError.class);

    private BlacklistedExceptions() {
    }

    public static void rethrowIfBlacklisted(Throwable exception) {
        if (blacklist.stream().anyMatch(exceptionType -> exceptionType.isInstance(exception))) {
            ExceptionUtils.throwAsUncheckedException(exception);
        }
    }
}

