/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public class ToStringBuilder {
    private final Class<?> type;
    private final List<String> values = new ArrayList<String>();

    public ToStringBuilder(Object obj) {
        this.type = Preconditions.notNull(obj, "Object must not be null").getClass();
    }

    public ToStringBuilder(Class<?> type) {
        this.type = Preconditions.notNull(type, "Class must not be null");
    }

    public ToStringBuilder append(String name, Object value) {
        Preconditions.notBlank(name, "Name must not be null or blank");
        this.values.add(name + " = " + this.toString(value));
        return this;
    }

    private String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            return "'" + obj + "'";
        }
        if (obj.getClass().isArray()) {
            return this.arrayToString(obj);
        }
        return Objects.toString(obj);
    }

    private String arrayToString(Object obj) {
        if (obj.getClass().getComponentType().isPrimitive()) {
            if (obj instanceof boolean[]) {
                return Arrays.toString((boolean[])obj);
            }
            if (obj instanceof char[]) {
                return Arrays.toString((char[])obj);
            }
            if (obj instanceof short[]) {
                return Arrays.toString((short[])obj);
            }
            if (obj instanceof byte[]) {
                return Arrays.toString((byte[])obj);
            }
            if (obj instanceof int[]) {
                return Arrays.toString((int[])obj);
            }
            if (obj instanceof long[]) {
                return Arrays.toString((long[])obj);
            }
            if (obj instanceof float[]) {
                return Arrays.toString((float[])obj);
            }
            if (obj instanceof double[]) {
                return Arrays.toString((double[])obj);
            }
        }
        return Arrays.deepToString((Object[])obj);
    }

    public String toString() {
        return this.type.getSimpleName() + " [" + String.join((CharSequence)", ", this.values) + "]";
    }
}

