/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;

final class CloseablePath
implements Closeable {
    private static final String JAR_URI_SCHEME = "jar";
    private static final String JAR_URI_SEPARATOR = "!";
    private static final Closeable NULL_CLOSEABLE = () -> {};
    private final Path path;
    private final Closeable delegate;

    static CloseablePath create(URI uri) throws IOException {
        if (JAR_URI_SCHEME.equals(uri.getScheme())) {
            String[] parts = uri.toString().split(JAR_URI_SEPARATOR);
            FileSystem fileSystem = FileSystems.newFileSystem(URI.create(parts[0]), Collections.emptyMap());
            return new CloseablePath(fileSystem.getPath(parts[1], new String[0]), fileSystem);
        }
        return new CloseablePath(Paths.get(uri), NULL_CLOSEABLE);
    }

    private CloseablePath(Path path, Closeable delegate) {
        this.path = path;
        this.delegate = delegate;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

