/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
public final class AnnotationUtils {
    private static final Map<AnnotationCacheKey, Annotation> annotationCache = new ConcurrentHashMap<AnnotationCacheKey, Annotation>(256);

    private AnnotationUtils() {
    }

    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType).isPresent();
    }

    public static <A extends Annotation> Optional<A> findAnnotation(Optional<? extends AnnotatedElement> element, Class<A> annotationType) {
        if (element == null || !element.isPresent()) {
            return Optional.empty();
        }
        return AnnotationUtils.findAnnotation(element.get(), annotationType, new HashSet<Annotation>());
    }

    public static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType, new HashSet<Annotation>());
    }

    private static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType, Set<Annotation> visited) {
        Preconditions.notNull(annotationType, "annotationType must not be null");
        if (element == null) {
            return Optional.empty();
        }
        AnnotationCacheKey key = new AnnotationCacheKey(element, annotationType);
        Annotation annotation = annotationCache.get(key);
        if (annotation != null) {
            return Optional.of(annotation);
        }
        annotation = element.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            annotationCache.put(key, annotation);
            return Optional.of(annotation);
        }
        Optional<A> directMetaAnnotation = AnnotationUtils.findMetaAnnotation(annotationType, element.getDeclaredAnnotations(), key, visited);
        if (directMetaAnnotation.isPresent()) {
            return directMetaAnnotation;
        }
        annotation = element.getAnnotation(annotationType);
        if (annotation != null) {
            annotationCache.put(key, annotation);
            return Optional.of(annotation);
        }
        Optional<A> indirectMetaAnnotation = AnnotationUtils.findMetaAnnotation(annotationType, element.getAnnotations(), key, visited);
        if (indirectMetaAnnotation.isPresent()) {
            return indirectMetaAnnotation;
        }
        return Optional.empty();
    }

    private static <A extends Annotation> Optional<A> findMetaAnnotation(Class<A> annotationType, Annotation[] candidates, AnnotationCacheKey key, Set<Annotation> visited) {
        for (Annotation candidateAnnotation : candidates) {
            Optional<A> metaAnnotation;
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotation) || !visited.add(candidateAnnotation) || !(metaAnnotation = AnnotationUtils.findAnnotation(candidateAnnotation.annotationType(), annotationType, visited)).isPresent()) continue;
            annotationCache.put(key, (Annotation)metaAnnotation.get());
            return metaAnnotation;
        }
        return Optional.empty();
    }

    public static <A extends Annotation> List<A> findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        Preconditions.notNull(annotationType, "annotationType must not be null");
        Repeatable repeatable = annotationType.getAnnotation(Repeatable.class);
        Preconditions.notNull(repeatable, () -> annotationType.getName() + " must be @Repeatable");
        Class<? extends Annotation> containerType = repeatable.value();
        boolean inherited = containerType.isAnnotationPresent(Inherited.class);
        if (element == null) {
            return Collections.emptyList();
        }
        LinkedHashSet found = new LinkedHashSet(16);
        AnnotationUtils.findRepeatableAnnotations(element, annotationType, containerType, inherited, found, new HashSet<Annotation>(16));
        return new ArrayList(found);
    }

    private static <A extends Annotation> void findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType, Class<? extends Annotation> containerType, boolean inherited, Set<A> found, Set<Annotation> visited) {
        if (element instanceof Class) {
            Class superclass;
            Class clazz = (Class)element;
            if (inherited && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
                AnnotationUtils.findRepeatableAnnotations(superclass, annotationType, containerType, inherited, found, visited);
            }
            for (Class<?> ifc : clazz.getInterfaces()) {
                if (ifc == Annotation.class) continue;
                AnnotationUtils.findRepeatableAnnotations(ifc, annotationType, containerType, inherited, found, visited);
            }
        }
        AnnotationUtils.findRepeatableAnnotations(element.getDeclaredAnnotations(), annotationType, containerType, inherited, found, visited);
        AnnotationUtils.findRepeatableAnnotations(element.getAnnotations(), annotationType, containerType, inherited, found, visited);
    }

    private static <A extends Annotation> void findRepeatableAnnotations(Annotation[] candidates, Class<A> annotationType, Class<? extends Annotation> containerType, boolean inherited, Set<A> found, Set<Annotation> visited) {
        for (Annotation candidate : candidates) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidate) || !visited.add(candidate)) continue;
            if (candidate.annotationType().equals(annotationType)) {
                found.add(annotationType.cast(candidate));
                continue;
            }
            if (candidate.annotationType().equals(containerType)) {
                Method method = ReflectionUtils.getMethod(containerType, "value", new Class[0]).get();
                Annotation[] containedAnnotations = (Annotation[])ReflectionUtils.invokeMethod(method, candidate, new Object[0]);
                found.addAll(Arrays.asList(containedAnnotations));
                continue;
            }
            AnnotationUtils.findRepeatableAnnotations(candidate.annotationType(), annotationType, containerType, inherited, found, visited);
        }
    }

    public static List<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType, ReflectionUtils.MethodSortOrder sortOrder) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(annotationType, "annotationType must not be null");
        return ReflectionUtils.findMethods(clazz, method -> AnnotationUtils.isAnnotated(method, annotationType), sortOrder);
    }

    private static boolean isInJavaLangAnnotationPackage(Annotation annotation) {
        return annotation != null && annotation.annotationType().getName().startsWith("java.lang.annotation");
    }

    private static class AnnotationCacheKey {
        private final AnnotatedElement element;
        private final Class<? extends Annotation> annotationType;

        AnnotationCacheKey(AnnotatedElement element, Class<? extends Annotation> annotationType) {
            this.element = element;
            this.annotationType = annotationType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AnnotationCacheKey) {
                AnnotationCacheKey that = (AnnotationCacheKey)obj;
                return Objects.equals(this.element, that.element) && Objects.equals(this.annotationType, that.annotationType);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.element, this.annotationType);
        }
    }
}

