/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.params.aggregator.AggregateWith;
import org.junit.jupiter.params.aggregator.ArgumentsAccessor;
import org.junit.jupiter.params.aggregator.ArgumentsAggregator;
import org.junit.jupiter.params.aggregator.DefaultArgumentsAccessor;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestMethodContext {
    private final Parameter[] parameters;
    private final Resolver[] resolvers;
    private final List<ResolverType> resolverTypes;

    ParameterizedTestMethodContext(Method testMethod) {
        this.parameters = testMethod.getParameters();
        this.resolvers = new Resolver[this.parameters.length];
        this.resolverTypes = new ArrayList<ResolverType>(this.parameters.length);
        for (Parameter parameter : this.parameters) {
            this.resolverTypes.add(ParameterizedTestMethodContext.isAggregator(parameter) ? ResolverType.AGGREGATOR : ResolverType.CONVERTER);
        }
    }

    private static boolean isAggregator(Parameter parameter) {
        return ArgumentsAccessor.class.isAssignableFrom(parameter.getType()) || AnnotationUtils.isAnnotated((AnnotatedElement)parameter, AggregateWith.class);
    }

    boolean hasPotentiallyValidSignature() {
        int indexOfPreviousAggregator = -1;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (!this.isAggregator(i)) continue;
            if (indexOfPreviousAggregator != -1 && i != indexOfPreviousAggregator + 1) {
                return false;
            }
            indexOfPreviousAggregator = i;
        }
        return true;
    }

    int getParameterCount() {
        return this.parameters.length;
    }

    Optional<String> getParameterName(int parameterIndex) {
        if (parameterIndex >= this.getParameterCount()) {
            return Optional.empty();
        }
        Parameter parameter = this.parameters[parameterIndex];
        if (!parameter.isNamePresent()) {
            return Optional.empty();
        }
        if (this.hasAggregator() && parameterIndex >= this.indexOfFirstAggregator()) {
            return Optional.empty();
        }
        return Optional.of(parameter.getName());
    }

    boolean hasAggregator() {
        return this.resolverTypes.contains((Object)ResolverType.AGGREGATOR);
    }

    boolean isAggregator(int parameterIndex) {
        return this.resolverTypes.get(parameterIndex) == ResolverType.AGGREGATOR;
    }

    int indexOfFirstAggregator() {
        return this.resolverTypes.indexOf((Object)ResolverType.AGGREGATOR);
    }

    Object resolve(ParameterContext parameterContext, Object[] arguments) {
        return this.getResolver(parameterContext).resolve(parameterContext, arguments);
    }

    private Resolver getResolver(ParameterContext parameterContext) {
        int index = parameterContext.getIndex();
        if (this.resolvers[index] == null) {
            this.resolvers[index] = this.resolverTypes.get(index).createResolver(parameterContext);
        }
        return this.resolvers[index];
    }

    private static ParameterResolutionException parameterResolutionException(String message, Exception cause, ParameterContext parameterContext) {
        String fullMessage = message + " at index " + parameterContext.getIndex();
        if (StringUtils.isNotBlank((String)cause.getMessage())) {
            fullMessage = fullMessage + ": " + cause.getMessage();
        }
        return new ParameterResolutionException(fullMessage, (Throwable)cause);
    }

    static class Aggregator
    implements Resolver {
        private static final Aggregator DEFAULT = new Aggregator((accessor, context) -> accessor);
        private final ArgumentsAggregator argumentsAggregator;

        Aggregator(ArgumentsAggregator argumentsAggregator) {
            this.argumentsAggregator = argumentsAggregator;
        }

        @Override
        public Object resolve(ParameterContext parameterContext, Object[] arguments) {
            DefaultArgumentsAccessor accessor = new DefaultArgumentsAccessor(arguments);
            try {
                return this.argumentsAggregator.aggregateArguments(accessor, parameterContext);
            }
            catch (Exception ex) {
                throw ParameterizedTestMethodContext.parameterResolutionException("Error aggregating arguments for parameter", ex, parameterContext);
            }
        }
    }

    static class Converter
    implements Resolver {
        private static final Converter DEFAULT = new Converter(DefaultArgumentConverter.INSTANCE);
        private final ArgumentConverter argumentConverter;

        Converter(ArgumentConverter argumentConverter) {
            this.argumentConverter = argumentConverter;
        }

        @Override
        public Object resolve(ParameterContext parameterContext, Object[] arguments) {
            Object argument = arguments[parameterContext.getIndex()];
            try {
                return this.argumentConverter.convert(argument, parameterContext);
            }
            catch (Exception ex) {
                throw ParameterizedTestMethodContext.parameterResolutionException("Error converting parameter", ex, parameterContext);
            }
        }
    }

    static interface Resolver {
        public Object resolve(ParameterContext var1, Object[] var2);
    }

    static enum ResolverType {
        CONVERTER{

            @Override
            Resolver createResolver(ParameterContext parameterContext) {
                try {
                    return AnnotationUtils.findAnnotation((AnnotatedElement)parameterContext.getParameter(), ConvertWith.class).map(ConvertWith::value).map(clazz -> (ArgumentConverter)ReflectionUtils.newInstance((Class)clazz, (Object[])new Object[0])).map(converter -> AnnotationConsumerInitializer.initialize(parameterContext.getParameter(), converter)).map(Converter::new).orElse(Converter.DEFAULT);
                }
                catch (Exception ex) {
                    throw ParameterizedTestMethodContext.parameterResolutionException("Error creating ArgumentConverter", ex, parameterContext);
                }
            }
        }
        ,
        AGGREGATOR{

            @Override
            Resolver createResolver(ParameterContext parameterContext) {
                try {
                    return AnnotationUtils.findAnnotation((AnnotatedElement)parameterContext.getParameter(), AggregateWith.class).map(AggregateWith::value).map(clazz -> (ArgumentsAggregator)ReflectionSupport.newInstance((Class)clazz, (Object[])new Object[0])).map(Aggregator::new).orElse(Aggregator.DEFAULT);
                }
                catch (Exception ex) {
                    throw ParameterizedTestMethodContext.parameterResolutionException("Error creating ArgumentsAggregator", ex, parameterContext);
                }
            }
        };


        abstract Resolver createResolver(ParameterContext var1);
    }
}

