/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ObjectArrayArguments;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class MethodArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<MethodSource> {
    private String[] methodNames;

    MethodArgumentsProvider() {
    }

    @Override
    public void accept(MethodSource annotation) {
        this.methodNames = annotation.names();
    }

    public Stream<Arguments> arguments(ContainerExtensionContext context) {
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new JUnitException("Cannot invoke method without test class"));
        return Arrays.stream(this.methodNames).map(methodName -> (Method)ReflectionUtils.findMethod((Class)testClass, (String)methodName, (Class[])new Class[0]).orElseThrow(() -> new JUnitException("Could not find method: " + methodName))).map(method -> ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[0])).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (item instanceof Object[]) {
            return ObjectArrayArguments.create((Object[])item);
        }
        return ObjectArrayArguments.create(item);
    }
}

