/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.com.univocity.parsers.common.processor.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.junit.jupiter.params.com.univocity.parsers.annotations.Nested;
import org.junit.jupiter.params.com.univocity.parsers.annotations.Parsed;
import org.junit.jupiter.params.com.univocity.parsers.annotations.helpers.AnnotationHelper;
import org.junit.jupiter.params.com.univocity.parsers.annotations.helpers.FieldMapping;
import org.junit.jupiter.params.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.com.univocity.parsers.common.Context;
import org.junit.jupiter.params.com.univocity.parsers.common.DataProcessingException;
import org.junit.jupiter.params.com.univocity.parsers.common.DefaultConversionProcessor;
import org.junit.jupiter.params.com.univocity.parsers.common.beans.PropertyWrapper;
import org.junit.jupiter.params.com.univocity.parsers.conversions.Conversion;

public class BeanConversionProcessor<T>
extends DefaultConversionProcessor {
    final Class<T> beanClass;
    protected final Set<FieldMapping> parsedFields = new LinkedHashSet<FieldMapping>();
    private int lastFieldIndexMapped = -1;
    private FieldMapping[] readOrder;
    private FieldMapping[] missing;
    private Object[] valuesForMissing;
    protected boolean initialized = false;
    boolean strictHeaderValidationEnabled = false;
    private String[] syntheticHeaders = null;
    private Object[] row;
    private Map<FieldMapping, BeanConversionProcessor<?>> nestedAttributes = null;

    public BeanConversionProcessor(Class<T> beanType) {
        this.beanClass = beanType;
    }

    public boolean isStrictHeaderValidationEnabled() {
        return this.strictHeaderValidationEnabled;
    }

    public final void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            Map<Field, PropertyWrapper> allFields = AnnotationHelper.getAllFields(this.beanClass);
            for (Map.Entry<Field, PropertyWrapper> e : allFields.entrySet()) {
                Field field = e.getKey();
                PropertyWrapper property = e.getValue();
                this.processField(field, property);
            }
            this.readOrder = null;
            this.lastFieldIndexMapped = -1;
            this.validateMappings();
        }
    }

    public void setStrictHeaderValidationEnabled(boolean strictHeaderValidationEnabled) {
        this.strictHeaderValidationEnabled = strictHeaderValidationEnabled;
    }

    void processField(Field field, PropertyWrapper propertyDescriptor) {
        Nested nested;
        FieldMapping mapping;
        Parsed annotation = AnnotationHelper.findAnnotation(field, Parsed.class);
        if (annotation != null && this.processField(mapping = new FieldMapping(this.beanClass, field, propertyDescriptor))) {
            this.parsedFields.add(mapping);
            this.setupConversions(field, mapping);
        }
        if ((nested = AnnotationHelper.findAnnotation(field, Nested.class)) != null) {
            Class<?> nestedType = nested.type();
            if (nestedType == Object.class) {
                nestedType = field.getType();
            }
            FieldMapping mapping2 = new FieldMapping(nestedType, field, propertyDescriptor);
            BeanConversionProcessor<?> processor = this.createNestedProcessor(nested, nestedType, mapping2);
            processor.initialize();
            this.getNestedAttributes().put(mapping2, processor);
        }
    }

    Map<FieldMapping, BeanConversionProcessor<?>> getNestedAttributes() {
        if (this.nestedAttributes == null) {
            this.nestedAttributes = new HashMap();
        }
        return this.nestedAttributes;
    }

    BeanConversionProcessor<?> createNestedProcessor(Annotation annotation, Class nestedType, FieldMapping fieldMapping) {
        return new BeanConversionProcessor<T>(nestedType);
    }

    protected boolean processField(FieldMapping field) {
        return true;
    }

    void validateMappings() {
        HashMap<String, FieldMapping> mappedNames = new HashMap<String, FieldMapping>();
        HashMap<Integer, FieldMapping> mappedIndexes = new HashMap<Integer, FieldMapping>();
        HashSet<FieldMapping> duplicateNames = new HashSet<FieldMapping>();
        HashSet<FieldMapping> duplicateIndexes = new HashSet<FieldMapping>();
        for (FieldMapping mapping : this.parsedFields) {
            String name = mapping.getFieldName();
            int index = mapping.getIndex();
            if (index != -1) {
                if (mappedIndexes.containsKey(index)) {
                    duplicateIndexes.add(mapping);
                    duplicateIndexes.add((FieldMapping)mappedIndexes.get(index));
                    continue;
                }
                mappedIndexes.put(index, mapping);
                continue;
            }
            if (mappedNames.containsKey(name)) {
                duplicateNames.add(mapping);
                duplicateNames.add((FieldMapping)mappedNames.get(name));
                continue;
            }
            mappedNames.put(name, mapping);
        }
        if (duplicateIndexes.size() > 0 || duplicateNames.size() > 0) {
            StringBuilder msg = new StringBuilder("Conflicting field mappings defined in annotated class: " + this.getBeanClass().getName());
            for (FieldMapping mapping : duplicateIndexes) {
                msg.append("\n\tIndex: '").append(mapping.getIndex()).append("' of  ").append(BeanConversionProcessor.describeField(mapping.getField()));
            }
            for (FieldMapping mapping : duplicateNames) {
                msg.append("\n\tName: '").append(mapping.getFieldName()).append("' of ").append(BeanConversionProcessor.describeField(mapping.getField()));
            }
            throw new DataProcessingException(msg.toString());
        }
    }

    static String describeField(Field field) {
        return "field '" + field.getName() + "' (" + field.getType().getName() + ')';
    }

    private void setupConversions(Field field, FieldMapping mapping) {
        Conversion defaultConversion;
        List<Annotation> annotations = AnnotationHelper.findAllAnnotationsInPackage(field, Parsed.class.getPackage());
        Conversion lastConversion = null;
        for (Annotation annotation : annotations) {
            try {
                Conversion conversion = AnnotationHelper.getConversion(field, annotation);
                if (conversion == null) continue;
                this.addConversion(conversion, mapping);
                lastConversion = conversion;
            }
            catch (Throwable ex) {
                String path = annotation.annotationType().getSimpleName() + "' of field " + mapping;
                throw new DataProcessingException("Error processing annotation '" + path + ". " + ex.getMessage(), ex);
            }
        }
        if (AnnotationHelper.findAnnotation(field, Parsed.class).applyDefaultConversion() && this.applyDefaultConversion(lastConversion, defaultConversion = AnnotationHelper.getDefaultConversion(field))) {
            this.addConversion(defaultConversion, mapping);
        }
    }

    private boolean applyDefaultConversion(Conversion lastConversionApplied, Conversion defaultConversion) {
        if (defaultConversion == null) {
            return false;
        }
        if (lastConversionApplied == null) {
            return true;
        }
        if (lastConversionApplied.getClass() == defaultConversion.getClass()) {
            return false;
        }
        Method execute = this.getConversionMethod(lastConversionApplied, "execute");
        Method revert = this.getConversionMethod(lastConversionApplied, "revert");
        Method defaultExecute = this.getConversionMethod(defaultConversion, "execute");
        Method defaultRevert = this.getConversionMethod(defaultConversion, "revert");
        return execute.getReturnType() != defaultExecute.getReturnType() || revert.getReturnType() != defaultRevert.getReturnType();
    }

    private Method getConversionMethod(Conversion conversion, String methodName) {
        Method targetMethod = null;
        for (Method method : conversion.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || method.isSynthetic() || method.isBridge() || (method.getModifiers() & 1) != 1 || method.getParameterTypes().length != 1 || method.getReturnType() == Void.class) continue;
            if (targetMethod != null) {
                throw new DataProcessingException("Unable to convert values for class '" + this.beanClass + "'. Multiple '" + methodName + "' methods defined in conversion " + conversion.getClass() + '.');
            }
            targetMethod = method;
        }
        if (targetMethod != null) {
            return targetMethod;
        }
        throw new DataProcessingException("Unable to convert values for class '" + this.beanClass + "'. Cannot find method '" + methodName + "' in conversion " + conversion.getClass() + '.');
    }

    protected void addConversion(Conversion conversion, FieldMapping mapping) {
        if (conversion == null) {
            return;
        }
        if (mapping.isMappedToIndex()) {
            this.convertIndexes(conversion).add((Integer[])new Integer[]{mapping.getIndex()});
        } else {
            this.convertFields(conversion).add((String[])new String[]{mapping.getFieldName()});
        }
    }

    void mapValuesToFields(T instance, Object[] row, Context context) {
        int i;
        if (row.length > this.lastFieldIndexMapped) {
            this.lastFieldIndexMapped = row.length;
            this.mapFieldIndexes(context, row, context.headers(), context.extractedFieldIndexes(), context.columnsReordered());
        }
        int last = row.length < this.readOrder.length ? row.length : this.readOrder.length;
        for (i = 0; i < last; ++i) {
            FieldMapping field = this.readOrder[i];
            if (field == null) continue;
            Object value = row[i];
            field.write(instance, value);
        }
        if (this.missing != null) {
            for (i = 0; i < this.missing.length; ++i) {
                Object value = this.valuesForMissing[i];
                if (value == null) continue;
                FieldMapping field = this.missing[i];
                field.write(instance, value);
            }
        }
    }

    private void mapFieldIndexes(Context context, Object[] row, String[] headers, int[] indexes, boolean columnsReordered) {
        if (headers == null) {
            headers = ArgumentUtils.EMPTY_STRING_ARRAY;
        }
        boolean boundToIndex = false;
        int last = headers.length > row.length ? headers.length : row.length;
        for (FieldMapping mapping : this.parsedFields) {
            int index = mapping.getIndex();
            if (last > index) continue;
            last = index;
            boundToIndex = true;
        }
        if (boundToIndex) {
            ++last;
        }
        FieldMapping[] fieldOrder = new FieldMapping[last];
        TreeSet<String> fieldsNotFound = new TreeSet<String>();
        for (FieldMapping mapping : this.parsedFields) {
            if (mapping.isMappedToField()) {
                int index = ArgumentUtils.indexOf(headers, mapping.getFieldName());
                if (index == -1) {
                    fieldsNotFound.add(mapping.getFieldName());
                    continue;
                }
                fieldOrder[index] = mapping;
                continue;
            }
            if (mapping.getIndex() >= fieldOrder.length) continue;
            fieldOrder[mapping.getIndex()] = mapping;
        }
        if (context != null && !fieldsNotFound.isEmpty()) {
            if (headers.length == 0) {
                throw new DataProcessingException("Could not find fields " + fieldsNotFound.toString() + " in input. Please enable header extraction in the parser settings in order to match field names.");
            }
            if (this.strictHeaderValidationEnabled) {
                DataProcessingException exception = new DataProcessingException("Could not find fields " + fieldsNotFound.toString() + "' in input. Names found: {headers}");
                exception.setValue("headers", Arrays.toString(headers));
                throw exception;
            }
        }
        if (indexes != null) {
            int j;
            for (int i = 0; i < fieldOrder.length; ++i) {
                boolean isIndexUsed = false;
                for (j = 0; j < indexes.length; ++j) {
                    if (indexes[j] != i) continue;
                    isIndexUsed = true;
                    break;
                }
                if (isIndexUsed) continue;
                fieldOrder[i] = null;
            }
            if (columnsReordered) {
                FieldMapping[] newFieldOrder = new FieldMapping[indexes.length];
                for (int i = 0; i < indexes.length; ++i) {
                    for (j = 0; j < fieldOrder.length; ++j) {
                        FieldMapping field;
                        int index = indexes[i];
                        if (index == -1) continue;
                        newFieldOrder[i] = field = fieldOrder[index];
                    }
                }
                fieldOrder = newFieldOrder;
            }
        }
        this.readOrder = fieldOrder;
        this.initializeValuesForMissing();
    }

    private void initializeValuesForMissing() {
        if (this.readOrder.length < this.parsedFields.size()) {
            LinkedHashSet<FieldMapping> unmapped = new LinkedHashSet<FieldMapping>(this.parsedFields);
            unmapped.removeAll(Arrays.asList(this.readOrder));
            this.missing = unmapped.toArray(new FieldMapping[0]);
            String[] headers = new String[this.missing.length];
            BeanConversionProcessor tmp = new BeanConversionProcessor(this.getBeanClass()){

                @Override
                protected void addConversion(Conversion conversion, FieldMapping mapping) {
                    if (conversion == null) {
                        return;
                    }
                    this.convertFields(conversion).add((String[])new String[]{mapping.getFieldName()});
                }
            };
            for (int i = 0; i < this.missing.length; ++i) {
                FieldMapping mapping = this.missing[i];
                if (this.processField(mapping)) {
                    super.setupConversions(mapping.getField(), mapping);
                }
                headers[i] = mapping.getFieldName();
            }
            tmp.initializeConversions(headers, null);
            this.valuesForMissing = tmp.applyConversions(new String[this.missing.length], null);
        } else {
            this.missing = null;
            this.valuesForMissing = null;
        }
    }

    public T createBean(String[] row, Context context) {
        T instance;
        Object[] convertedRow = super.applyConversions(row, context);
        if (convertedRow == null) {
            return null;
        }
        try {
            instance = this.beanClass.newInstance();
        }
        catch (Throwable e) {
            throw new DataProcessingException("Unable to instantiate class '" + this.beanClass.getName() + '\'', row, e);
        }
        this.mapValuesToFields(instance, convertedRow, context);
        if (this.nestedAttributes != null) {
            this.processNestedAttributes(row, instance, context);
        }
        return instance;
    }

    void processNestedAttributes(String[] row, Object instance, Context context) {
        for (Map.Entry<FieldMapping, BeanConversionProcessor<?>> e : this.nestedAttributes.entrySet()) {
            Object nested = e.getValue().createBean(row, context);
            if (nested == null) continue;
            e.getKey().write(instance, nested);
        }
    }

    private void mapFieldsToValues(T instance, Object[] row, String[] headers, int[] indexes, boolean columnsReordered) {
        if (row.length > this.lastFieldIndexMapped) {
            this.mapFieldIndexes(null, row, headers, indexes, columnsReordered);
        }
        int last = row.length < this.readOrder.length ? row.length : this.readOrder.length;
        for (int i = 0; i < last; ++i) {
            FieldMapping field = this.readOrder[i];
            if (field == null) continue;
            try {
                row[i] = field.read(instance);
                continue;
            }
            catch (Throwable e) {
                if (!this.beanClass.isAssignableFrom(instance.getClass())) {
                    this.handleConversionError(e, new Object[]{instance}, -1);
                    throw this.toDataProcessingException(e, row, i);
                }
                if (this.handleConversionError(e, row, i)) continue;
                throw this.toDataProcessingException(e, row, i);
            }
        }
    }

    public final Object[] reverseConversions(T bean, String[] headers, int[] indexesToWrite) {
        if (bean == null) {
            return null;
        }
        if (this.row == null) {
            if (headers != null) {
                this.row = new Object[headers.length];
            } else if (indexesToWrite != null) {
                int minimumRowLength = 0;
                for (int index : indexesToWrite) {
                    if (index + 1 <= minimumRowLength) continue;
                    minimumRowLength = index + 1;
                }
                if (minimumRowLength < indexesToWrite.length) {
                    minimumRowLength = indexesToWrite.length;
                }
                this.row = new Object[minimumRowLength];
            } else {
                HashSet<Integer> assignedIndexes = new HashSet<Integer>();
                int lastIndex = -1;
                for (FieldMapping f : this.parsedFields) {
                    if (lastIndex < f.getIndex() + 1) {
                        lastIndex = f.getIndex() + 1;
                    }
                    assignedIndexes.add(f.getIndex());
                }
                if (lastIndex < this.parsedFields.size()) {
                    lastIndex = this.parsedFields.size();
                }
                this.row = new Object[lastIndex];
                if (this.syntheticHeaders == null) {
                    this.syntheticHeaders = new String[lastIndex];
                    Iterator<FieldMapping> it = this.parsedFields.iterator();
                    for (int i = 0; i < lastIndex; ++i) {
                        if (assignedIndexes.contains(i)) continue;
                        String fieldName = null;
                        while (it.hasNext() && (fieldName = it.next().getFieldName()) == null) {
                        }
                        this.syntheticHeaders[i] = fieldName;
                    }
                }
            }
        }
        if (this.nestedAttributes != null) {
            for (Map.Entry<FieldMapping, BeanConversionProcessor<?>> e : this.nestedAttributes.entrySet()) {
                Object nested = e.getKey().read(bean);
                if (nested == null) continue;
                BeanConversionProcessor<?> nestedProcessor = e.getValue();
                nestedProcessor.row = this.row;
                nestedProcessor.reverseConversions(nested, headers, indexesToWrite);
            }
        }
        if (this.syntheticHeaders != null) {
            headers = this.syntheticHeaders;
        }
        try {
            this.mapFieldsToValues(bean, this.row, headers, indexesToWrite, false);
        }
        catch (Throwable ex) {
            if (ex instanceof DataProcessingException) {
                DataProcessingException error = (DataProcessingException)ex;
                if (error.isHandled()) {
                    return null;
                }
                throw error;
            }
            if (!this.handleConversionError(ex, this.row, -1)) {
                throw this.toDataProcessingException(ex, this.row, -1);
            }
            return null;
        }
        if (super.reverseConversions(true, this.row, headers, indexesToWrite)) {
            return this.row;
        }
        return null;
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }
}

