/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.com.univocity.parsers.common.input;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.params.com.univocity.parsers.common.Format;
import org.junit.jupiter.params.com.univocity.parsers.common.input.CharInputReader;
import org.junit.jupiter.params.com.univocity.parsers.common.input.EOFException;
import org.junit.jupiter.params.com.univocity.parsers.common.input.ExpandingCharAppender;
import org.junit.jupiter.params.com.univocity.parsers.common.input.InputAnalysisProcess;
import org.junit.jupiter.params.com.univocity.parsers.common.input.LineSeparatorDetector;

public abstract class AbstractCharInputReader
implements CharInputReader {
    private final ExpandingCharAppender tmp;
    private boolean lineSeparatorDetected;
    private final boolean detectLineSeparator;
    private List<InputAnalysisProcess> inputAnalysisProcesses;
    private char lineSeparator1;
    private char lineSeparator2;
    private final char normalizedLineSeparator;
    private long lineCount;
    private long charCount;
    private int recordStart;
    final int whitespaceRangeStart;
    public int i;
    private char ch;
    public char[] buffer;
    public int length = -1;
    private boolean incrementLineCount;
    private boolean normalizeLineEndings = true;

    public AbstractCharInputReader(char normalizedLineSeparator, int whitespaceRangeStart) {
        this(null, normalizedLineSeparator, whitespaceRangeStart);
    }

    public AbstractCharInputReader(char[] lineSeparator, char normalizedLineSeparator, int whitespaceRangeStart) {
        this.whitespaceRangeStart = whitespaceRangeStart;
        this.tmp = new ExpandingCharAppender(4096, null, whitespaceRangeStart);
        if (lineSeparator == null) {
            this.detectLineSeparator = true;
            this.submitLineSeparatorDetector();
            this.lineSeparator1 = '\u0000';
            this.lineSeparator2 = '\u0000';
        } else {
            this.setLineSeparator(lineSeparator);
            this.detectLineSeparator = false;
        }
        this.normalizedLineSeparator = normalizedLineSeparator;
    }

    private void submitLineSeparatorDetector() {
        if (this.detectLineSeparator && !this.lineSeparatorDetected) {
            this.addInputAnalysisProcess(new LineSeparatorDetector(){

                @Override
                protected void apply(char separator1, char separator2) {
                    if (separator1 != '\u0000') {
                        AbstractCharInputReader.this.lineSeparatorDetected = true;
                        AbstractCharInputReader.this.lineSeparator1 = separator1;
                        AbstractCharInputReader.this.lineSeparator2 = separator2;
                    } else {
                        AbstractCharInputReader.this.setLineSeparator(Format.getSystemLineSeparator());
                    }
                }
            });
        }
    }

    private void setLineSeparator(char[] lineSeparator) {
        if (lineSeparator == null || lineSeparator.length == 0) {
            throw new IllegalArgumentException("Invalid line separator. Expected 1 to 2 characters");
        }
        if (lineSeparator.length > 2) {
            throw new IllegalArgumentException("Invalid line separator. Up to 2 characters are expected. Got " + lineSeparator.length + " characters.");
        }
        this.lineSeparator1 = lineSeparator[0];
        this.lineSeparator2 = lineSeparator.length == 2 ? lineSeparator[1] : (char)'\u0000';
    }

    protected abstract void setReader(Reader var1);

    protected abstract void reloadBuffer();

    @Override
    public final void start(Reader reader) {
        this.stop();
        this.setReader(reader);
        this.lineCount = 0L;
        this.lineSeparatorDetected = false;
        this.submitLineSeparatorDetector();
        this.updateBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBuffer() {
        if (this.length - this.recordStart > 0 && this.buffer != null) {
            this.tmp.append(this.buffer, this.recordStart, this.length - this.recordStart);
        }
        this.recordStart = 0;
        this.reloadBuffer();
        this.charCount += (long)this.i;
        this.i = 0;
        if (this.length == -1) {
            this.stop();
            this.incrementLineCount = true;
        }
        if (this.inputAnalysisProcesses != null) {
            try {
                for (InputAnalysisProcess process : this.inputAnalysisProcesses) {
                    process.execute(this.buffer, this.length);
                }
            }
            finally {
                this.inputAnalysisProcesses = null;
            }
        }
    }

    public final void addInputAnalysisProcess(InputAnalysisProcess inputAnalysisProcess) {
        if (inputAnalysisProcess == null) {
            return;
        }
        if (this.inputAnalysisProcesses == null) {
            this.inputAnalysisProcesses = new ArrayList<InputAnalysisProcess>();
        }
        this.inputAnalysisProcesses.add(inputAnalysisProcess);
    }

    private void throwEOFException() {
        if (this.incrementLineCount) {
            ++this.lineCount;
        }
        this.ch = '\u0000';
        throw new EOFException();
    }

    @Override
    public final char nextChar() {
        if (this.length == -1) {
            this.throwEOFException();
        }
        this.ch = this.buffer[this.i++];
        if (this.i >= this.length) {
            this.updateBuffer();
        }
        if (this.lineSeparator1 == this.ch && (this.lineSeparator2 == '\u0000' || this.length != -1 && this.lineSeparator2 == this.buffer[this.i])) {
            ++this.lineCount;
            if (this.normalizeLineEndings) {
                this.ch = this.normalizedLineSeparator;
                if (this.lineSeparator2 == '\u0000') {
                    return this.ch;
                }
                if (++this.i >= this.length) {
                    if (this.length != -1) {
                        this.updateBuffer();
                    } else {
                        this.throwEOFException();
                    }
                }
            }
        }
        return this.ch;
    }

    @Override
    public final char getChar() {
        return this.ch;
    }

    @Override
    public final long lineCount() {
        return this.lineCount;
    }

    @Override
    public final void skipLines(long lines) {
        if (lines < 1L) {
            return;
        }
        long expectedLineCount = this.lineCount + lines;
        try {
            do {
                this.nextChar();
            } while (this.lineCount < expectedLineCount);
            if (this.lineCount < lines) {
                throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - lines) + ". End of input reached");
            }
        }
        catch (EOFException ex) {
            throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - lines) + ". End of input reached");
        }
    }

    @Override
    public String readComment() {
        long expectedLineCount = this.lineCount + 1L;
        try {
            while (true) {
                char ch;
                if ((ch = this.nextChar()) <= ' ' && this.whitespaceRangeStart < ch) {
                    ch = this.skipWhitespace(ch, this.normalizedLineSeparator, this.normalizedLineSeparator);
                }
                this.tmp.appendUntil(ch, this, this.normalizedLineSeparator, this.normalizedLineSeparator);
                if (this.lineCount >= expectedLineCount) break;
                this.tmp.appendIgnoringWhitespace(this.nextChar());
            }
            this.tmp.updateWhitespace();
            return this.tmp.getAndReset();
        }
        catch (EOFException ex) {
            this.tmp.updateWhitespace();
            return this.tmp.getAndReset();
        }
    }

    @Override
    public final long charCount() {
        return this.charCount + (long)this.i;
    }

    @Override
    public final void enableNormalizeLineEndings(boolean normalizeLineEndings) {
        this.normalizeLineEndings = normalizeLineEndings;
    }

    @Override
    public char[] getLineSeparator() {
        if (this.lineSeparator2 != '\u0000') {
            return new char[]{this.lineSeparator1, this.lineSeparator2};
        }
        return new char[]{this.lineSeparator1};
    }

    @Override
    public final char skipWhitespace(char ch, char stopChar1, char stopChar2) {
        while (ch <= ' ' && ch != stopChar1 && ch != this.normalizedLineSeparator && ch != stopChar2 && this.whitespaceRangeStart < ch) {
            ch = this.nextChar();
        }
        return ch;
    }

    @Override
    public final String currentParsedContent() {
        if (this.tmp.length() == 0) {
            if (this.i > this.recordStart) {
                return new String(this.buffer, this.recordStart, this.i - this.recordStart);
            }
            return null;
        }
        if (this.i > this.recordStart) {
            this.tmp.append(this.buffer, this.recordStart, this.i - this.recordStart);
        }
        return this.tmp.getAndReset();
    }

    @Override
    public final void markRecordStart() {
        this.tmp.reset();
        this.recordStart = this.i <= 0 ? 0 : this.i - 1;
    }

    @Override
    public String getString(char ch, char stop, boolean trim, String nullValue, int maxLength) {
        if (this.i == 0) {
            return null;
        }
        int i = this.i;
        while (ch != stop) {
            if (i >= this.length) {
                return null;
            }
            if (this.lineSeparator1 == ch && (this.lineSeparator2 == '\u0000' || this.lineSeparator2 == this.buffer[i])) break;
            ch = this.buffer[i++];
        }
        int pos = this.i - 1;
        int len = i - this.i;
        if (len > maxLength) {
            return null;
        }
        this.i = i - 1;
        if (trim) {
            i -= 2;
            while (this.buffer[i] <= ' ' && this.whitespaceRangeStart < this.buffer[i]) {
                --len;
                --i;
            }
        }
        String out = len <= 0 ? nullValue : new String(this.buffer, pos, len);
        this.nextChar();
        return out;
    }
}

