/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.text.MessageFormat;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class ParameterizedTestNameFormatter {
    private final String namePattern;

    ParameterizedTestNameFormatter(String namePattern) {
        this.namePattern = namePattern;
    }

    String format(int invocationIndex, Object ... arguments) {
        String result = this.namePattern.replace("{index}", String.valueOf(invocationIndex));
        if (result.contains("{arguments}")) {
            String replacement = IntStream.range(0, arguments.length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
            result = result.replace("{arguments}", replacement);
        }
        return MessageFormat.format(result, arguments);
    }
}

