/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.api.io.CleanupMode;
import org.junit.jupiter.api.io.TempDirFactory;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;

@API(status=API.Status.INTERNAL, since="5.4")
public class CachingJupiterConfiguration
implements JupiterConfiguration {
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();
    private final JupiterConfiguration delegate;

    public CachingJupiterConfiguration(JupiterConfiguration delegate) {
        this.delegate = delegate;
    }

    @Override
    public Predicate<Class<? extends Extension>> getFilterForAutoDetectedExtensions() {
        return this.delegate.getFilterForAutoDetectedExtensions();
    }

    @Override
    public Optional<String> getRawConfigurationParameter(String key) {
        return this.delegate.getRawConfigurationParameter(key);
    }

    @Override
    public <T> Optional<T> getRawConfigurationParameter(String key, Function<? super String, ? extends T> transformer) {
        return this.delegate.getRawConfigurationParameter(key, transformer);
    }

    @Override
    public boolean isParallelExecutionEnabled() {
        return (Boolean)this.cache.computeIfAbsent("junit.jupiter.execution.parallel.enabled", __ -> this.delegate.isParallelExecutionEnabled());
    }

    @Override
    public boolean isClosingStoredAutoCloseablesEnabled() {
        return (Boolean)this.cache.computeIfAbsent("junit.jupiter.extensions.store.close.autocloseable.enabled", __ -> this.delegate.isClosingStoredAutoCloseablesEnabled());
    }

    @Override
    public boolean isExtensionAutoDetectionEnabled() {
        return (Boolean)this.cache.computeIfAbsent("junit.jupiter.extensions.autodetection.enabled", __ -> this.delegate.isExtensionAutoDetectionEnabled());
    }

    @Override
    public boolean isThreadDumpOnTimeoutEnabled() {
        return (Boolean)this.cache.computeIfAbsent("junit.jupiter.execution.timeout.threaddump.enabled", __ -> this.delegate.isThreadDumpOnTimeoutEnabled());
    }

    @Override
    public ExecutionMode getDefaultExecutionMode() {
        return (ExecutionMode)this.cache.computeIfAbsent("junit.jupiter.execution.parallel.mode.default", __ -> this.delegate.getDefaultExecutionMode());
    }

    @Override
    public ExecutionMode getDefaultClassesExecutionMode() {
        return (ExecutionMode)this.cache.computeIfAbsent("junit.jupiter.execution.parallel.mode.classes.default", __ -> this.delegate.getDefaultClassesExecutionMode());
    }

    @Override
    public TestInstance.Lifecycle getDefaultTestInstanceLifecycle() {
        return (TestInstance.Lifecycle)this.cache.computeIfAbsent("junit.jupiter.testinstance.lifecycle.default", __ -> this.delegate.getDefaultTestInstanceLifecycle());
    }

    @Override
    public Predicate<ExecutionCondition> getExecutionConditionFilter() {
        return (Predicate)this.cache.computeIfAbsent("junit.jupiter.conditions.deactivate", __ -> this.delegate.getExecutionConditionFilter());
    }

    @Override
    public DisplayNameGenerator getDefaultDisplayNameGenerator() {
        return (DisplayNameGenerator)this.cache.computeIfAbsent("junit.jupiter.displayname.generator.default", __ -> this.delegate.getDefaultDisplayNameGenerator());
    }

    @Override
    public Optional<MethodOrderer> getDefaultTestMethodOrderer() {
        return (Optional)this.cache.computeIfAbsent("junit.jupiter.testmethod.order.default", __ -> this.delegate.getDefaultTestMethodOrderer());
    }

    @Override
    public Optional<ClassOrderer> getDefaultTestClassOrderer() {
        return (Optional)this.cache.computeIfAbsent("junit.jupiter.testclass.order.default", __ -> this.delegate.getDefaultTestClassOrderer());
    }

    @Override
    public CleanupMode getDefaultTempDirCleanupMode() {
        return (CleanupMode)this.cache.computeIfAbsent("junit.jupiter.tempdir.cleanup.mode.default", __ -> this.delegate.getDefaultTempDirCleanupMode());
    }

    @Override
    public Supplier<TempDirFactory> getDefaultTempDirFactorySupplier() {
        return (Supplier)this.cache.computeIfAbsent("junit.jupiter.tempdir.factory.default", __ -> this.delegate.getDefaultTempDirFactorySupplier());
    }

    @Override
    public TestInstantiationAwareExtension.ExtensionContextScope getDefaultTestInstantiationExtensionContextScope() {
        return (TestInstantiationAwareExtension.ExtensionContextScope)this.cache.computeIfAbsent("junit.jupiter.extensions.testinstantiation.extensioncontextscope.default", __ -> this.delegate.getDefaultTestInstantiationExtensionContextScope());
    }

    @Override
    public OutputDirectoryProvider getOutputDirectoryProvider() {
        return this.delegate.getOutputDirectoryProvider();
    }
}

