/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.engine.discovery.AbstractAnnotatedDescriptorWrapper;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

abstract class AbstractOrderingVisitor
implements TestDescriptor.Visitor {
    private final DiscoveryIssueReporter issueReporter;

    AbstractOrderingVisitor(DiscoveryIssueReporter issueReporter) {
        this.issueReporter = issueReporter;
    }

    protected <PARENT extends TestDescriptor> void doWithMatchingDescriptor(Class<PARENT> parentTestDescriptorType, TestDescriptor testDescriptor, Consumer<PARENT> action, Function<PARENT, String> errorMessageBuilder) {
        if (parentTestDescriptorType.isInstance(testDescriptor)) {
            TestDescriptor parentTestDescriptor = testDescriptor;
            try {
                action.accept(parentTestDescriptor);
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
                String message = errorMessageBuilder.apply(parentTestDescriptor);
                this.issueReporter.reportIssue(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.ERROR, (String)message).source(parentTestDescriptor.getSource()).cause(t));
            }
        }
    }

    protected <CHILD extends TestDescriptor, WRAPPER extends AbstractAnnotatedDescriptorWrapper<?>> void orderChildrenTestDescriptors(TestDescriptor parentTestDescriptor, Class<CHILD> matchingChildrenType, Optional<Consumer<CHILD>> validationAction, Function<CHILD, WRAPPER> descriptorWrapperFactory, DescriptorWrapperOrderer<?, WRAPPER> descriptorWrapperOrderer) {
        List matchingDescriptorWrappers;
        Stream<TestDescriptor> matchingChildren = parentTestDescriptor.getChildren().stream().filter(matchingChildrenType::isInstance).map(matchingChildrenType::cast);
        if (!descriptorWrapperOrderer.canOrderWrappers()) {
            validationAction.ifPresent(matchingChildren::forEach);
            return;
        }
        if (validationAction.isPresent()) {
            matchingChildren = matchingChildren.peek(validationAction.get());
        }
        if ((matchingDescriptorWrappers = (List)matchingChildren.map(descriptorWrapperFactory).collect(Collectors.toCollection(ArrayList::new))).isEmpty()) {
            return;
        }
        parentTestDescriptor.orderChildren(children -> {
            Stream<TestDescriptor> nonMatchingTestDescriptors = children.stream().filter(childTestDescriptor -> !matchingChildrenType.isInstance(childTestDescriptor));
            descriptorWrapperOrderer.orderWrappers(matchingDescriptorWrappers, message -> this.reportWarning(parentTestDescriptor, (String)message));
            Stream<TestDescriptor> orderedTestDescriptors = matchingDescriptorWrappers.stream().map(AbstractAnnotatedDescriptorWrapper::getTestDescriptor);
            if (this.shouldNonMatchingDescriptorsComeBeforeOrderedOnes()) {
                return Stream.concat(nonMatchingTestDescriptors, orderedTestDescriptors).toList();
            }
            return Stream.concat(orderedTestDescriptors, nonMatchingTestDescriptors).toList();
        });
    }

    private void reportWarning(TestDescriptor parentTestDescriptor, String message) {
        this.issueReporter.reportIssue(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message).source(parentTestDescriptor.getSource()));
    }

    protected abstract boolean shouldNonMatchingDescriptorsComeBeforeOrderedOnes();

    protected static class DescriptorWrapperOrderer<ORDERER, WRAPPER> {
        private static final DescriptorWrapperOrderer<?, ?> NOOP = new DescriptorWrapperOrderer(null, null, __ -> "", ___ -> "");
        private final @Nullable ORDERER orderer;
        private final @Nullable Consumer<List<WRAPPER>> orderingAction;
        private final MessageGenerator descriptorsAddedMessageGenerator;
        private final MessageGenerator descriptorsRemovedMessageGenerator;

        protected static <ORDERER, WRAPPER> DescriptorWrapperOrderer<ORDERER, WRAPPER> noop() {
            return NOOP;
        }

        DescriptorWrapperOrderer(@Nullable ORDERER orderer, @Nullable Consumer<List<WRAPPER>> orderingAction, MessageGenerator descriptorsAddedMessageGenerator, MessageGenerator descriptorsRemovedMessageGenerator) {
            this.orderer = orderer;
            this.orderingAction = orderingAction;
            this.descriptorsAddedMessageGenerator = descriptorsAddedMessageGenerator;
            this.descriptorsRemovedMessageGenerator = descriptorsRemovedMessageGenerator;
        }

        @Nullable ORDERER getOrderer() {
            return this.orderer;
        }

        private boolean canOrderWrappers() {
            return this.orderingAction != null;
        }

        private void orderWrappers(List<WRAPPER> wrappers, Consumer<String> errorHandler) {
            ArrayList<WRAPPER> orderedWrappers = new ArrayList<WRAPPER>(wrappers);
            Objects.requireNonNull(this.orderingAction).accept(orderedWrappers);
            Map<Object, Integer> distinctWrappersToIndex = this.distinctWrappersToIndex(orderedWrappers);
            int difference = orderedWrappers.size() - wrappers.size();
            int distinctDifference = distinctWrappersToIndex.size() - wrappers.size();
            if (difference > 0) {
                this.reportDescriptorsAddedWarning(difference, errorHandler);
            }
            if (distinctDifference < 0) {
                this.reportDescriptorsRemovedWarning(distinctDifference, errorHandler);
            }
            wrappers.sort(Comparator.comparing(wrapper -> distinctWrappersToIndex.getOrDefault(wrapper, -1)));
        }

        private Map<Object, Integer> distinctWrappersToIndex(List<?> wrappers) {
            HashMap<Object, Integer> toIndex = new HashMap<Object, Integer>();
            for (int i = 0; i < wrappers.size(); ++i) {
                Object wrapper = wrappers.get(i);
                if (toIndex.containsKey(wrapper)) continue;
                toIndex.put(wrapper, i);
            }
            return toIndex;
        }

        private void reportDescriptorsAddedWarning(int number, Consumer<String> errorHandler) {
            errorHandler.accept(this.descriptorsAddedMessageGenerator.generateMessage(number));
        }

        private void reportDescriptorsRemovedWarning(int number, Consumer<String> errorHandler) {
            errorHandler.accept(this.descriptorsRemovedMessageGenerator.generateMessage(Math.abs(number)));
        }
    }

    @FunctionalInterface
    protected static interface MessageGenerator {
        public String generateMessage(int var1);
    }
}

