/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.jupiter.engine.descriptor.ClassExtensionContext;
import org.junit.jupiter.engine.descriptor.DefaultTestInstanceFactoryContext;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.LifecycleMethodUtils;
import org.junit.jupiter.engine.descriptor.TestInstanceLifecycleUtils;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.execution.TestInstanceProvider;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.0")
public class ClassTestDescriptor
extends JupiterTestDescriptor {
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();
    private final Class<?> testClass;
    private final Set<TestTag> tags;
    protected final TestInstance.Lifecycle lifecycle;
    private TestInstanceFactory testInstanceFactory;
    private List<Method> beforeAllMethods;
    private List<Method> afterAllMethods;

    public ClassTestDescriptor(UniqueId uniqueId, Class<?> testClass, ConfigurationParameters configurationParameters) {
        this(uniqueId, ClassTestDescriptor::generateDefaultDisplayName, testClass, configurationParameters);
    }

    protected ClassTestDescriptor(UniqueId uniqueId, Function<Class<?>, String> defaultDisplayNameGenerator, Class<?> testClass, ConfigurationParameters configurationParameters) {
        super(uniqueId, ClassTestDescriptor.determineDisplayName((Class)Preconditions.notNull(testClass, (String)"Class must not be null"), defaultDisplayNameGenerator), (TestSource)ClassSource.from(testClass));
        this.testClass = testClass;
        this.tags = ClassTestDescriptor.getTags(testClass);
        this.lifecycle = TestInstanceLifecycleUtils.getTestInstanceLifecycle(testClass, configurationParameters);
    }

    public Set<TestTag> getTags() {
        return new LinkedHashSet<TestTag>(this.tags);
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public String getLegacyReportingName() {
        return this.testClass.getName();
    }

    private static String generateDefaultDisplayName(Class<?> testClass) {
        String name = testClass.getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    @Override
    protected Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return this.getExecutionModeFromAnnotation(this.getTestClass());
    }

    @Override
    protected Optional<Node.ExecutionMode> getDefaultChildExecutionMode() {
        return this.lifecycle == TestInstance.Lifecycle.PER_CLASS ? Optional.of(Node.ExecutionMode.SAME_THREAD) : Optional.empty();
    }

    public Set<ExclusiveResource> getExclusiveResources() {
        return this.getExclusiveResourcesFromAnnotation(this.getTestClass());
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context.getExtensionRegistry(), this.testClass);
        ExtensionUtils.registerExtensionsFromFields(registry, this.testClass, null);
        this.testInstanceFactory = this.resolveTestInstanceFactory(registry);
        this.registerBeforeEachMethodAdapters(registry);
        this.registerAfterEachMethodAdapters(registry);
        OpenTest4JAwareThrowableCollector throwableCollector = new OpenTest4JAwareThrowableCollector();
        ClassExtensionContext extensionContext = new ClassExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, this.lifecycle, context.getConfigurationParameters(), (ThrowableCollector)throwableCollector);
        this.beforeAllMethods = LifecycleMethodUtils.findBeforeAllMethods(this.testClass, this.lifecycle == TestInstance.Lifecycle.PER_METHOD);
        this.afterAllMethods = LifecycleMethodUtils.findAfterAllMethods(this.testClass, this.lifecycle == TestInstance.Lifecycle.PER_METHOD);
        return context.extend().withTestInstanceProvider(this.testInstanceProvider(context, registry, extensionContext)).withExtensionRegistry(registry).withExtensionContext(extensionContext).withThrowableCollector((ThrowableCollector)throwableCollector).build();
    }

    public JupiterEngineExecutionContext before(JupiterEngineExecutionContext context) {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        TestInstance.Lifecycle lifecycle = context.getExtensionContext().getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
        if (lifecycle == TestInstance.Lifecycle.PER_CLASS) {
            ClassExtensionContext extensionContext = (ClassExtensionContext)context.getExtensionContext();
            throwableCollector.execute(() -> extensionContext.setTestInstance(context.getTestInstanceProvider().getTestInstance(Optional.empty())));
        }
        if (throwableCollector.isEmpty()) {
            context.beforeAllCallbacksExecuted(true);
            this.invokeBeforeAllCallbacks(context);
            if (throwableCollector.isEmpty()) {
                context.beforeAllMethodsExecuted(true);
                this.invokeBeforeAllMethods(context);
            }
        }
        throwableCollector.assertEmpty();
        return context;
    }

    public void after(JupiterEngineExecutionContext context) {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Throwable previousThrowable = throwableCollector.getThrowable();
        if (context.beforeAllMethodsExecuted()) {
            this.invokeAfterAllMethods(context);
        }
        if (context.beforeAllCallbacksExecuted()) {
            this.invokeAfterAllCallbacks(context);
        }
        if (previousThrowable != throwableCollector.getThrowable()) {
            throwableCollector.assertEmpty();
        }
    }

    private TestInstanceFactory resolveTestInstanceFactory(ExtensionRegistry registry) {
        List<TestInstanceFactory> localFactories = registry.getLocalExtensions(TestInstanceFactory.class);
        if (localFactories.isEmpty()) {
            return null;
        }
        ExtensionRegistry parentRegistry = registry.getParent();
        if (parentRegistry != null) {
            List<TestInstanceFactory> parentFactories = parentRegistry.getExtensions(TestInstanceFactory.class);
            localFactories.removeAll(parentFactories);
            if (localFactories.isEmpty()) {
                return null;
            }
        }
        if (localFactories.size() > 1) {
            String factoryNames = localFactories.stream().map(factory -> factory.getClass().getName()).collect(Collectors.joining(", "));
            String errorMessage = String.format("The following TestInstanceFactory extensions were registered for test class [%s], but only one is permitted: %s", this.testClass.getName(), factoryNames);
            throw new ExtensionConfigurationException(errorMessage);
        }
        return localFactories.get(0);
    }

    private TestInstanceProvider testInstanceProvider(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ClassExtensionContext extensionContext) {
        TestInstanceProvider testInstanceProvider = childRegistry -> this.instantiateAndPostProcessTestInstance(parentExecutionContext, extensionContext, childRegistry.orElse(registry));
        return childRegistry -> extensionContext.getTestInstance().orElseGet(() -> testInstanceProvider.getTestInstance(childRegistry));
    }

    private Object instantiateAndPostProcessTestInstance(JupiterEngineExecutionContext parentExecutionContext, ExtensionContext extensionContext, ExtensionRegistry registry) {
        Object instance = this.instantiateTestClass(parentExecutionContext, registry, extensionContext);
        this.invokeTestInstancePostProcessors(instance, registry, extensionContext);
        ExtensionUtils.registerExtensionsFromFields(registry, this.testClass, instance);
        return instance;
    }

    protected Object instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ExtensionContext extensionContext) {
        return this.instantiateTestClass(Optional.empty(), registry, extensionContext);
    }

    protected Object instantiateTestClass(Optional<Object> outerInstance, ExtensionRegistry registry, ExtensionContext extensionContext) {
        return this.testInstanceFactory != null ? this.invokeTestInstanceFactory(outerInstance, extensionContext) : this.invokeTestClassConstructor(outerInstance, registry, extensionContext);
    }

    private Object invokeTestInstanceFactory(Optional<Object> outerInstance, ExtensionContext extensionContext) {
        Object instance;
        try {
            instance = this.testInstanceFactory.createTestInstance((TestInstanceFactoryContext)new DefaultTestInstanceFactoryContext(this.testClass, outerInstance), extensionContext);
        }
        catch (Throwable throwable) {
            BlacklistedExceptions.rethrowIfBlacklisted((Throwable)throwable);
            if (throwable instanceof TestInstantiationException) {
                throw (TestInstantiationException)throwable;
            }
            String message = String.format("TestInstanceFactory [%s] failed to instantiate test class [%s]", this.testInstanceFactory.getClass().getName(), this.testClass.getName());
            if (StringUtils.isNotBlank((String)throwable.getMessage())) {
                message = message + ": " + throwable.getMessage();
            }
            throw new TestInstantiationException(message, throwable);
        }
        if (!this.testClass.isInstance(instance)) {
            String instanceClassName;
            String testClassName = this.testClass.getName();
            Class<?> instanceClass = instance == null ? null : instance.getClass();
            String string = instanceClassName = instanceClass == null ? "null" : instanceClass.getName();
            if (testClassName.equals(instanceClassName)) {
                testClassName = testClassName + "@" + Integer.toHexString(System.identityHashCode(this.testClass));
                instanceClassName = instanceClassName + "@" + Integer.toHexString(System.identityHashCode(instanceClass));
            }
            String message = String.format("TestInstanceFactory [%s] failed to return an instance of [%s] and instead returned an instance of [%s].", this.testInstanceFactory.getClass().getName(), testClassName, instanceClassName);
            throw new TestInstantiationException(message);
        }
        return instance;
    }

    private Object invokeTestClassConstructor(Optional<Object> outerInstance, ExtensionRegistry registry, ExtensionContext extensionContext) {
        Constructor constructor = ReflectionUtils.getDeclaredConstructor(this.testClass);
        return outerInstance.isPresent() ? executableInvoker.invoke(constructor, outerInstance.get(), extensionContext, registry) : executableInvoker.invoke(constructor, extensionContext, registry);
    }

    private void invokeTestInstancePostProcessors(Object instance, ExtensionRegistry registry, ExtensionContext context) {
        registry.stream(TestInstancePostProcessor.class).forEach(extension -> this.executeAndMaskThrowable(() -> extension.postProcessTestInstance(instance, context)));
    }

    private void invokeBeforeAllCallbacks(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (BeforeAllCallback callback : registry.getExtensions(BeforeAllCallback.class)) {
            throwableCollector.execute(() -> callback.beforeAll(extensionContext));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeBeforeAllMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        for (Method method : this.beforeAllMethods) {
            throwableCollector.execute(() -> executableInvoker.invoke(method, testInstance, extensionContext, registry));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeAfterAllMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        this.afterAllMethods.forEach(method -> throwableCollector.execute(() -> executableInvoker.invoke((Method)method, (Object)testInstance, extensionContext, registry)));
    }

    private void invokeAfterAllCallbacks(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        registry.getReversedExtensions(AfterAllCallback.class).forEach(extension -> throwableCollector.execute(() -> extension.afterAll(extensionContext)));
    }

    private void registerBeforeEachMethodAdapters(ExtensionRegistry registry) {
        List<Method> beforeEachMethods = LifecycleMethodUtils.findBeforeEachMethods(this.testClass);
        this.registerMethodsAsExtensions(beforeEachMethods, registry, this::synthesizeBeforeEachMethodAdapter);
    }

    private void registerAfterEachMethodAdapters(ExtensionRegistry registry) {
        ArrayList<Method> afterEachMethods = new ArrayList<Method>(LifecycleMethodUtils.findAfterEachMethods(this.testClass));
        Collections.reverse(afterEachMethods);
        this.registerMethodsAsExtensions(afterEachMethods, registry, this::synthesizeAfterEachMethodAdapter);
    }

    private void registerMethodsAsExtensions(List<Method> methods, ExtensionRegistry registry, Function<Method, Extension> extensionSynthesizer) {
        methods.forEach(method -> registry.registerExtension((Extension)extensionSynthesizer.apply((Method)method), method));
    }

    private BeforeEachMethodAdapter synthesizeBeforeEachMethodAdapter(Method method) {
        return (extensionContext, registry) -> this.invokeMethodInExtensionContext(method, extensionContext, registry);
    }

    private AfterEachMethodAdapter synthesizeAfterEachMethodAdapter(Method method) {
        return (extensionContext, registry) -> this.invokeMethodInExtensionContext(method, extensionContext, registry);
    }

    private void invokeMethodInExtensionContext(Method method, ExtensionContext context, ExtensionRegistry registry) {
        Object testInstance = context.getRequiredTestInstance();
        testInstance = ReflectionUtils.getOutermostInstance((Object)testInstance, method.getDeclaringClass()).orElseThrow(() -> new JUnitException("Failed to find instance for method: " + method.toGenericString()));
        executableInvoker.invoke(method, testInstance, context, registry);
    }
}

