/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.engine.discovery.AbstractAnnotatedDescriptorWrapper;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestDescriptor;

abstract class AbstractOrderingVisitor
implements TestDescriptor.Visitor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOrderingVisitor.class);

    AbstractOrderingVisitor() {
    }

    protected <PARENT extends TestDescriptor> void doWithMatchingDescriptor(Class<PARENT> parentTestDescriptorType, TestDescriptor testDescriptor, Consumer<PARENT> action, Function<PARENT, String> errorMessageBuilder) {
        if (parentTestDescriptorType.isInstance(testDescriptor)) {
            TestDescriptor parentTestDescriptor = testDescriptor;
            try {
                action.accept(parentTestDescriptor);
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
                logger.error(t, () -> (String)errorMessageBuilder.apply(parentTestDescriptor));
            }
        }
    }

    protected <CHILD extends TestDescriptor, WRAPPER extends AbstractAnnotatedDescriptorWrapper<?>> void orderChildrenTestDescriptors(TestDescriptor parentTestDescriptor, Class<CHILD> matchingChildrenType, Function<CHILD, WRAPPER> descriptorWrapperFactory, DescriptorWrapperOrderer<WRAPPER> descriptorWrapperOrderer) {
        if (!descriptorWrapperOrderer.canOrderWrappers()) {
            return;
        }
        List matchingDescriptorWrappers = parentTestDescriptor.getChildren().stream().filter(matchingChildrenType::isInstance).map(matchingChildrenType::cast).map(descriptorWrapperFactory).collect(Collectors.toCollection(ArrayList::new));
        if (matchingDescriptorWrappers.isEmpty()) {
            return;
        }
        parentTestDescriptor.orderChildren(children -> {
            Stream<TestDescriptor> nonMatchingTestDescriptors = children.stream().filter(childTestDescriptor -> !matchingChildrenType.isInstance(childTestDescriptor));
            descriptorWrapperOrderer.orderWrappers(matchingDescriptorWrappers);
            Stream<TestDescriptor> orderedTestDescriptors = matchingDescriptorWrappers.stream().map(AbstractAnnotatedDescriptorWrapper::getTestDescriptor);
            if (this.shouldNonMatchingDescriptorsComeBeforeOrderedOnes()) {
                return Stream.concat(nonMatchingTestDescriptors, orderedTestDescriptors).collect(Collectors.toList());
            }
            return Stream.concat(orderedTestDescriptors, nonMatchingTestDescriptors).collect(Collectors.toList());
        });
    }

    protected abstract boolean shouldNonMatchingDescriptorsComeBeforeOrderedOnes();

    protected static class DescriptorWrapperOrderer<WRAPPER> {
        private static final DescriptorWrapperOrderer<?> NOOP = new DescriptorWrapperOrderer(null, __ -> "", ___ -> "");
        private final Consumer<List<WRAPPER>> orderingAction;
        private final MessageGenerator descriptorsAddedMessageGenerator;
        private final MessageGenerator descriptorsRemovedMessageGenerator;

        protected static <WRAPPER> DescriptorWrapperOrderer<WRAPPER> noop() {
            return NOOP;
        }

        DescriptorWrapperOrderer(Consumer<List<WRAPPER>> orderingAction, MessageGenerator descriptorsAddedMessageGenerator, MessageGenerator descriptorsRemovedMessageGenerator) {
            this.orderingAction = orderingAction;
            this.descriptorsAddedMessageGenerator = descriptorsAddedMessageGenerator;
            this.descriptorsRemovedMessageGenerator = descriptorsRemovedMessageGenerator;
        }

        private boolean canOrderWrappers() {
            return this.orderingAction != null;
        }

        private void orderWrappers(List<WRAPPER> wrappers) {
            ArrayList<WRAPPER> orderedWrappers = new ArrayList<WRAPPER>(wrappers);
            this.orderingAction.accept(orderedWrappers);
            Map<Object, Integer> distinctWrappersToIndex = this.distinctWrappersToIndex(orderedWrappers);
            int difference = orderedWrappers.size() - wrappers.size();
            int distinctDifference = distinctWrappersToIndex.size() - wrappers.size();
            if (difference > 0) {
                this.logDescriptorsAddedWarning(difference);
            }
            if (distinctDifference < 0) {
                this.logDescriptorsRemovedWarning(distinctDifference);
            }
            wrappers.sort(Comparator.comparing(wrapper -> distinctWrappersToIndex.getOrDefault(wrapper, -1)));
        }

        private Map<Object, Integer> distinctWrappersToIndex(List<?> wrappers) {
            HashMap<Object, Integer> toIndex = new HashMap<Object, Integer>();
            for (int i = 0; i < wrappers.size(); ++i) {
                Object wrapper = wrappers.get(i);
                if (toIndex.containsKey(wrapper)) continue;
                toIndex.put(wrapper, i);
            }
            return toIndex;
        }

        private void logDescriptorsAddedWarning(int number) {
            logger.warn(() -> this.descriptorsAddedMessageGenerator.generateMessage(number));
        }

        private void logDescriptorsRemovedWarning(int number) {
            logger.warn(() -> this.descriptorsRemovedMessageGenerator.generateMessage(Math.abs(number)));
        }
    }

    @FunctionalInterface
    protected static interface MessageGenerator {
        public String generateMessage(int var1);
    }
}

