/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor;
import org.junit.jupiter.engine.discovery.AbstractMethodResolver;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

@API(value=API.Usage.Experimental)
class TestFactoryMethodResolver
extends AbstractMethodResolver {
    private static final Predicate<Method> isTestFactoryMethod = new IsTestFactoryMethod();
    static final String SEGMENT_TYPE = "test-factory";

    TestFactoryMethodResolver() {
        super(SEGMENT_TYPE, isTestFactoryMethod);
    }

    @Override
    protected TestDescriptor createTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method method) {
        return new TestFactoryTestDescriptor(uniqueId, testClass, method);
    }
}

