/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.discovery.ElementResolver;
import org.junit.jupiter.engine.discovery.MethodFinder;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

@API(value=API.Usage.Experimental)
abstract class AbstractMethodResolver
implements ElementResolver {
    private static final MethodFinder methodFinder = new MethodFinder();
    private final String segmentType;
    private final Predicate<Method> methodPredicate;

    AbstractMethodResolver(String segmentType, Predicate<Method> methodPredicate) {
        this.segmentType = segmentType;
        this.methodPredicate = methodPredicate;
    }

    @Override
    public Set<TestDescriptor> resolveElement(AnnotatedElement element, TestDescriptor parent) {
        if (!(element instanceof Method)) {
            return Collections.emptySet();
        }
        if (!(parent instanceof ClassTestDescriptor)) {
            return Collections.emptySet();
        }
        Method method = (Method)element;
        if (!this.isRelevantMethod(method)) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.createTestDescriptor(parent, method));
    }

    @Override
    public Optional<TestDescriptor> resolveUniqueId(UniqueId.Segment segment, TestDescriptor parent) {
        if (!segment.getType().equals(this.segmentType)) {
            return Optional.empty();
        }
        if (!(parent instanceof ClassTestDescriptor)) {
            return Optional.empty();
        }
        Optional<Method> optionalMethod = this.findMethod(segment, (ClassTestDescriptor)parent);
        if (!optionalMethod.isPresent()) {
            return Optional.empty();
        }
        Method method = optionalMethod.get();
        if (!this.isRelevantMethod(method)) {
            return Optional.empty();
        }
        return Optional.of(this.createTestDescriptor(parent, method));
    }

    private boolean isRelevantMethod(Method candidate) {
        return this.methodPredicate.test(candidate);
    }

    private UniqueId createUniqueId(Method method, TestDescriptor parent) {
        String methodId = String.format("%s(%s)", method.getName(), ClassUtils.nullSafeToString((Class[])method.getParameterTypes()));
        return parent.getUniqueId().append(this.segmentType, methodId);
    }

    private Optional<Method> findMethod(UniqueId.Segment segment, ClassTestDescriptor parent) {
        return methodFinder.findMethod(segment.getValue(), parent.getTestClass());
    }

    private TestDescriptor createTestDescriptor(TestDescriptor parent, Method method) {
        UniqueId uniqueId = this.createUniqueId(method, parent);
        Class<?> testClass = ((ClassTestDescriptor)parent).getTestClass();
        return this.createTestDescriptor(uniqueId, testClass, method);
    }

    protected abstract TestDescriptor createTestDescriptor(UniqueId var1, Class<?> var2, Method var3);
}

