/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.discovery.ElementResolver;
import org.junit.jupiter.engine.discovery.predicates.IsInnerClass;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

@API(value=API.Usage.Experimental)
class JavaElementsResolver {
    private static final Logger LOG = Logger.getLogger(JavaElementsResolver.class.getName());
    private static final IsInnerClass isInnerClass = new IsInnerClass();
    private final TestDescriptor engineDescriptor;
    private final Set<ElementResolver> resolvers;

    JavaElementsResolver(TestDescriptor engineDescriptor, Set<ElementResolver> resolvers) {
        this.engineDescriptor = engineDescriptor;
        this.resolvers = resolvers;
    }

    void resolveClass(Class<?> testClass) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveContainerWithParents(testClass);
        resolvedDescriptors.forEach(this::resolveChildren);
        if (resolvedDescriptors.isEmpty()) {
            LOG.warning(() -> String.format("Class '%s' could not be resolved", testClass.getName()));
        }
    }

    void resolveMethod(Class<?> testClass, Method testMethod) {
        Set<TestDescriptor> potentialParents = this.resolveContainerWithParents(testClass);
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(testMethod, potentialParents);
        if (resolvedDescriptors.isEmpty()) {
            LOG.warning(() -> String.format("Method '%s' could not be resolved", testMethod.toGenericString()));
        }
    }

    private Set<TestDescriptor> resolveContainerWithParents(Class<?> testClass) {
        if (isInnerClass.test(testClass)) {
            Set<TestDescriptor> potentialParents = this.resolveContainerWithParents(testClass.getDeclaringClass());
            return this.resolveForAllParents(testClass, potentialParents);
        }
        return this.resolveForAllParents(testClass, Collections.singleton(this.engineDescriptor));
    }

    void resolveUniqueId(UniqueId uniqueId) {
        List segments = uniqueId.getSegments();
        segments.remove(0);
        if (!this.resolveUniqueId(this.engineDescriptor, segments)) {
            LOG.warning(() -> String.format("Unique ID '%s' could not be resolved", uniqueId));
        }
    }

    private boolean resolveUniqueId(TestDescriptor parent, List<UniqueId.Segment> remainingSegments) {
        if (remainingSegments.isEmpty()) {
            this.resolveChildren(parent);
            return true;
        }
        UniqueId.Segment head = remainingSegments.remove(0);
        for (ElementResolver resolver : this.resolvers) {
            Optional<TestDescriptor> resolvedDescriptor = resolver.resolveUniqueId(head, parent);
            if (!resolvedDescriptor.isPresent()) continue;
            Optional<TestDescriptor> foundTestDescriptor = this.findTestDescriptorByUniqueId(resolvedDescriptor.get().getUniqueId());
            TestDescriptor descriptor = foundTestDescriptor.orElseGet(() -> {
                TestDescriptor newDescriptor = (TestDescriptor)resolvedDescriptor.get();
                parent.addChild(newDescriptor);
                return newDescriptor;
            });
            return this.resolveUniqueId(descriptor, remainingSegments);
        }
        return false;
    }

    private Set<TestDescriptor> resolveContainerWithChildren(Class<?> containerClass, Set<TestDescriptor> potentialParents) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(containerClass, potentialParents);
        resolvedDescriptors.forEach(this::resolveChildren);
        return resolvedDescriptors;
    }

    private Set<TestDescriptor> resolveForAllParents(AnnotatedElement element, Set<TestDescriptor> potentialParents) {
        HashSet<TestDescriptor> resolvedDescriptors = new HashSet<TestDescriptor>();
        potentialParents.forEach(parent -> resolvedDescriptors.addAll(this.resolve(element, (TestDescriptor)parent)));
        return resolvedDescriptors;
    }

    private void resolveChildren(TestDescriptor descriptor) {
        if (descriptor instanceof ClassTestDescriptor) {
            Class<?> testClass = ((ClassTestDescriptor)descriptor).getTestClass();
            this.resolveContainedMethods(descriptor, testClass);
            this.resolveContainedNestedClasses(descriptor, testClass);
        }
    }

    private void resolveContainedNestedClasses(TestDescriptor containerDescriptor, Class<?> clazz) {
        List nestedClassesCandidates = ReflectionUtils.findNestedClasses(clazz, (Predicate)isInnerClass);
        nestedClassesCandidates.forEach(nestedClass -> this.resolveContainerWithChildren((Class<?>)nestedClass, Collections.singleton(containerDescriptor)));
    }

    private void resolveContainedMethods(TestDescriptor containerDescriptor, Class<?> testClass) {
        List testMethodCandidates = ReflectionUtils.findMethods(testClass, method -> !ReflectionUtils.isPrivate((Member)method), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
        testMethodCandidates.forEach(method -> this.resolve((AnnotatedElement)method, containerDescriptor));
    }

    private Set<TestDescriptor> resolve(AnnotatedElement element, TestDescriptor parent) {
        return this.resolvers.stream().map(resolver -> this.tryToResolveWithResolver(element, parent, (ElementResolver)resolver)).filter(testDescriptors -> !testDescriptors.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<TestDescriptor> tryToResolveWithResolver(AnnotatedElement element, TestDescriptor parent, ElementResolver resolver) {
        Set<TestDescriptor> resolvedDescriptors = resolver.resolveElement(element, parent);
        LinkedHashSet<TestDescriptor> result = new LinkedHashSet<TestDescriptor>();
        resolvedDescriptors.forEach(testDescriptor -> {
            Optional<TestDescriptor> existingTestDescriptor = this.findTestDescriptorByUniqueId(testDescriptor.getUniqueId());
            if (existingTestDescriptor.isPresent()) {
                result.add(existingTestDescriptor.get());
            } else {
                parent.addChild(testDescriptor);
                result.add((TestDescriptor)testDescriptor);
            }
        });
        return result;
    }

    private Optional<TestDescriptor> findTestDescriptorByUniqueId(UniqueId uniqueId) {
        return this.engineDescriptor.findByUniqueId(uniqueId);
    }
}

