/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.support.io;

import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.EXPERIMENTAL, since="5.4")
public final class TempDirectory
implements ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create(TempDirectory.class);
    private static final String KEY = "temp.dir";
    private static final String TEMP_DIR_PREFIX = "junit";
    private final TempDirProvider tempDirProvider;

    private TempDirectory(TempDirProvider tempDirProvider) {
        this.tempDirProvider = (TempDirProvider)Preconditions.notNull((Object)tempDirProvider, (String)"TempDirProvider must not be null");
    }

    public TempDirectory() {
        this((__, ___, dirPrefix) -> TempDirectory.createDefaultTempDir(dirPrefix));
    }

    public static TempDirectory createInDefaultDirectory() {
        return new TempDirectory();
    }

    public static TempDirectory createInCustomDirectory(ParentDirProvider parentDirProvider) {
        Preconditions.notNull((Object)parentDirProvider, (String)"ParentDirProvider must not be null");
        return new TempDirectory((parameterContext, extensionContext, dirPrefix) -> TempDirectory.createCustomTempDir(parentDirProvider, parameterContext, extensionContext, dirPrefix));
    }

    public static TempDirectory createInCustomDirectory(Callable<Path> parentDirProvider) {
        Preconditions.notNull(parentDirProvider, (String)"parentDirProvider must not be null");
        return TempDirectory.createInCustomDirectory((ParameterContext parameterContext, ExtensionContext extensionContext) -> (Path)parentDirProvider.call());
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.isAnnotated(TempDir.class);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType != Path.class) {
            throw new ParameterResolutionException("Can only resolve parameter of type " + Path.class.getName() + " but was: " + parameterType.getName());
        }
        return extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent(KEY, key -> this.tempDirProvider.get(parameterContext, extensionContext, TEMP_DIR_PREFIX), CloseablePath.class).get();
    }

    private static CloseablePath createDefaultTempDir(String dirPrefix) {
        try {
            return new CloseablePath(Files.createTempDirectory(dirPrefix, new FileAttribute[0]));
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Failed to create default temp directory", ex);
        }
    }

    private static CloseablePath createCustomTempDir(ParentDirProvider parentDirProvider, ParameterContext parameterContext, ExtensionContext extensionContext, String dirPrefix) {
        Path parentDir;
        try {
            parentDir = parentDirProvider.get(parameterContext, extensionContext);
            Preconditions.notNull((Object)parentDir, (String)"ParentDirProvider returned null for the parent directory");
        }
        catch (Exception ex) {
            throw new ParameterResolutionException("Failed to get parent directory from provider", ex);
        }
        try {
            return new CloseablePath(Files.createTempDirectory(parentDir, dirPrefix, new FileAttribute[0]));
        }
        catch (Exception ex) {
            throw new ParameterResolutionException("Failed to create custom temp directory", ex);
        }
    }

    private static class CloseablePath
    implements ExtensionContext.Store.CloseableResource {
        private final Path dir;

        CloseablePath(Path dir) {
            this.dir = dir;
        }

        Path get() {
            return this.dir;
        }

        @Override
        public void close() throws IOException {
            SortedMap<Path, IOException> failures = this.deleteAllFilesAndDirectories();
            if (!failures.isEmpty()) {
                throw this.createIOExceptionWithAttachedFailures(failures);
            }
        }

        private SortedMap<Path, IOException> deleteAllFilesAndDirectories() throws IOException {
            final TreeMap<Path, IOException> failures = new TreeMap<Path, IOException>();
            Files.walkFileTree(this.dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    return this.deleteAndContinue(file);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return this.deleteAndContinue(dir);
                }

                private FileVisitResult deleteAndContinue(Path path) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException ex) {
                        failures.put(path, ex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return failures;
        }

        private IOException createIOExceptionWithAttachedFailures(SortedMap<Path, IOException> failures) {
            String joinedPaths = failures.keySet().stream().peek(this::tryToDeleteOnExit).map(this::relativizeSafely).map(String::valueOf).collect(Collectors.joining(", "));
            IOException exception = new IOException("Failed to delete temp directory " + this.dir.toAbsolutePath() + ". The following paths could not be deleted (see suppressed exceptions for details): " + joinedPaths);
            failures.values().forEach(exception::addSuppressed);
            return exception;
        }

        private void tryToDeleteOnExit(Path path) {
            try {
                path.toFile().deleteOnExit();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        private Path relativizeSafely(Path path) {
            try {
                return this.dir.relativize(path);
            }
            catch (IllegalArgumentException e) {
                return path;
            }
        }
    }

    @FunctionalInterface
    private static interface TempDirProvider {
        public CloseablePath get(ParameterContext var1, ExtensionContext var2, String var3);
    }

    @FunctionalInterface
    public static interface ParentDirProvider {
        public Path get(ParameterContext var1, ExtensionContext var2) throws Exception;
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface TempDir {
    }
}

