/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.extension;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.gen5.api.extension.ExtensionConfigurationException;
import org.junit.gen5.api.extension.ExtensionPoint;
import org.junit.gen5.api.extension.ExtensionPointRegistry;
import org.junit.gen5.engine.junit5.extension.RegisteredExtensionPoint;

class ExtensionPointSorter {
    ExtensionPointSorter() {
    }

    public <T extends ExtensionPoint> void sort(List<RegisteredExtensionPoint<T>> registeredExtensionPoints) {
        this.checkPositionUnique(registeredExtensionPoints, ExtensionPointRegistry.Position.INNERMOST);
        this.checkPositionUnique(registeredExtensionPoints, ExtensionPointRegistry.Position.OUTERMOST);
        registeredExtensionPoints.sort(new DefaultComparator());
    }

    private <T extends ExtensionPoint> void checkPositionUnique(List<RegisteredExtensionPoint<T>> registeredExtensionPoints, ExtensionPointRegistry.Position positionType) {
        if (this.countPosition(registeredExtensionPoints, positionType) > 1L) {
            List<String> conflictingExtensions = this.conflictingExtensions(registeredExtensionPoints, positionType);
            String exceptionMessage = String.format("Conflicting extensions: %s", conflictingExtensions);
            throw new ExtensionConfigurationException(exceptionMessage);
        }
    }

    private <T extends ExtensionPoint> long countPosition(List<RegisteredExtensionPoint<T>> registeredExtensionPoints, ExtensionPointRegistry.Position positionToCount) {
        return registeredExtensionPoints.stream().filter(point -> point.getPosition() == positionToCount).count();
    }

    private <T extends ExtensionPoint> List<String> conflictingExtensions(List<RegisteredExtensionPoint<T>> registeredExtensionPoints, ExtensionPointRegistry.Position positionToFind) {
        return registeredExtensionPoints.stream().filter(point -> point.getPosition() == positionToFind).map(RegisteredExtensionPoint::getSource).map(Object::toString).collect(Collectors.toList());
    }

    private static class DefaultComparator
    implements Comparator<RegisteredExtensionPoint<?>> {
        private DefaultComparator() {
        }

        @Override
        public int compare(RegisteredExtensionPoint<?> first, RegisteredExtensionPoint<?> second) {
            return Integer.compare(first.getPosition().ordinal(), second.getPosition().ordinal());
        }
    }
}

