/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.gen5.api.extension.AfterEachExtensionPoint;
import org.junit.gen5.api.extension.BeforeEachExtensionPoint;
import org.junit.gen5.api.extension.ConditionEvaluationResult;
import org.junit.gen5.api.extension.ExceptionHandlerExtensionPoint;
import org.junit.gen5.api.extension.ExtensionContext;
import org.junit.gen5.api.extension.InstancePostProcessor;
import org.junit.gen5.api.extension.MethodInvocationContext;
import org.junit.gen5.api.extension.TestExtensionContext;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ExceptionUtils;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.commons.util.StringUtils;
import org.junit.gen5.engine.TestSource;
import org.junit.gen5.engine.TestTag;
import org.junit.gen5.engine.junit5.descriptor.JUnit5TestDescriptor;
import org.junit.gen5.engine.junit5.descriptor.MethodBasedTestExtensionContext;
import org.junit.gen5.engine.junit5.execution.ConditionEvaluator;
import org.junit.gen5.engine.junit5.execution.JUnit5EngineExecutionContext;
import org.junit.gen5.engine.junit5.execution.MethodInvocationContextFactory;
import org.junit.gen5.engine.junit5.execution.MethodInvoker;
import org.junit.gen5.engine.junit5.execution.ThrowableCollector;
import org.junit.gen5.engine.junit5.extension.ExtensionRegistry;
import org.junit.gen5.engine.junit5.extension.RegisteredExtensionPoint;
import org.junit.gen5.engine.support.descriptor.JavaSource;
import org.junit.gen5.engine.support.hierarchical.Leaf;
import org.junit.gen5.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public class MethodTestDescriptor
extends JUnit5TestDescriptor
implements Leaf<JUnit5EngineExecutionContext> {
    private final String displayName;
    private final Class<?> testClass;
    private final Method testMethod;

    public MethodTestDescriptor(String uniqueId, Class<?> testClass, Method testMethod) {
        super(uniqueId);
        this.testClass = (Class)Preconditions.notNull(testClass, (String)"Class must not be null");
        this.testMethod = (Method)Preconditions.notNull((Object)testMethod, (String)"Method must not be null");
        this.displayName = this.determineDisplayName(testMethod, testMethod.getName());
        this.setSource((TestSource)new JavaSource(testMethod));
    }

    public final Set<TestTag> getTags() {
        Set<TestTag> methodTags = this.getTags(this.getTestMethod());
        this.getParent().ifPresent(parentDescriptor -> methodTags.addAll(parentDescriptor.getTags()));
        return methodTags;
    }

    public String getName() {
        return String.format("%s#%s(%s)", this.getTestClass().getName(), this.testMethod.getName(), StringUtils.nullSafeToString((Class[])this.testMethod.getParameterTypes()));
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final Method getTestMethod() {
        return this.testMethod;
    }

    public final boolean isTest() {
        return true;
    }

    public final boolean isContainer() {
        return false;
    }

    public JUnit5EngineExecutionContext prepare(JUnit5EngineExecutionContext context) throws Exception {
        ExtensionRegistry extensionRegistry = this.populateNewExtensionRegistryFromExtendWith(this.testMethod, context.getExtensionRegistry());
        Object testInstance = context.getTestInstanceProvider().getTestInstance();
        MethodBasedTestExtensionContext testExtensionContext = new MethodBasedTestExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, testInstance);
        return context.extend().withExtensionRegistry(extensionRegistry).withExtensionContext(testExtensionContext).build();
    }

    public Node.SkipResult shouldBeSkipped(JUnit5EngineExecutionContext context) throws Exception {
        ConditionEvaluationResult evaluationResult = new ConditionEvaluator().evaluateForTest(context.getExtensionRegistry(), (TestExtensionContext)context.getExtensionContext());
        if (evaluationResult.isDisabled()) {
            return Node.SkipResult.skip((String)evaluationResult.getReason().orElse(""));
        }
        return Node.SkipResult.dontSkip();
    }

    public JUnit5EngineExecutionContext execute(JUnit5EngineExecutionContext context) throws Exception {
        TestExtensionContext testExtensionContext = (TestExtensionContext)context.getExtensionContext();
        ThrowableCollector throwableCollector = new ThrowableCollector();
        this.invokeInstancePostProcessorExtensionPoints(context.getExtensionRegistry(), testExtensionContext);
        this.invokeBeforeEachExtensionPoints(context.getExtensionRegistry(), testExtensionContext);
        this.invokeTestMethod(context.getExtensionRegistry(), testExtensionContext, throwableCollector);
        this.invokeAfterEachExtensionPoints(context.getExtensionRegistry(), testExtensionContext, throwableCollector);
        throwableCollector.assertEmpty();
        return context;
    }

    private void invokeInstancePostProcessorExtensionPoints(ExtensionRegistry extensionRegistry, TestExtensionContext testExtensionContext) throws Exception {
        Consumer<RegisteredExtensionPoint> applyInstancePostProcessor = registeredExtensionPoint -> this.executeAndMaskThrowable(() -> ((InstancePostProcessor)registeredExtensionPoint.getExtensionPoint()).postProcessTestInstance(testExtensionContext));
        extensionRegistry.stream(InstancePostProcessor.class, ExtensionRegistry.ApplicationOrder.FORWARD).forEach(applyInstancePostProcessor);
    }

    private void invokeBeforeEachExtensionPoints(ExtensionRegistry extensionRegistry, TestExtensionContext testExtensionContext) throws Exception {
        Consumer<RegisteredExtensionPoint> applyBeforeEach = registeredExtensionPoint -> this.executeAndMaskThrowable(() -> ((BeforeEachExtensionPoint)registeredExtensionPoint.getExtensionPoint()).beforeEach(testExtensionContext));
        extensionRegistry.stream(BeforeEachExtensionPoint.class, ExtensionRegistry.ApplicationOrder.FORWARD).forEach(applyBeforeEach);
    }

    private void invokeTestMethod(ExtensionRegistry ExtensionRegistry2, TestExtensionContext testExtensionContext, ThrowableCollector throwableCollector) {
        throwableCollector.execute(() -> {
            MethodInvocationContext methodInvocationContext = MethodInvocationContextFactory.methodInvocationContext(testExtensionContext.getTestInstance(), testExtensionContext.getTestMethod());
            try {
                new MethodInvoker((ExtensionContext)testExtensionContext, ExtensionRegistry2).invoke(methodInvocationContext);
            }
            catch (Throwable throwable) {
                this.invokeExceptionHandlerExtensionPoints(ExtensionRegistry2, testExtensionContext, throwable);
            }
        });
    }

    private void invokeExceptionHandlerExtensionPoints(ExtensionRegistry extensionRegistry, TestExtensionContext testExtensionContext, Throwable throwable) {
        List<ExceptionHandlerExtensionPoint> exceptionHandlers = this.collectExceptionHandlerExtensionPoints(extensionRegistry);
        this.executeExceptionHandlers(throwable, exceptionHandlers, testExtensionContext);
    }

    private void executeExceptionHandlers(Throwable throwable, List<ExceptionHandlerExtensionPoint> exceptionHandlers, TestExtensionContext testExtensionContext) {
        this.rethrowExceptionIfThereIsNoHandlerLeft(throwable, exceptionHandlers);
        try {
            this.executeFirstExceptionHandler(throwable, exceptionHandlers, testExtensionContext);
        }
        catch (Throwable t) {
            this.executeExceptionHandlers(t, exceptionHandlers, testExtensionContext);
        }
    }

    private void executeFirstExceptionHandler(Throwable throwable, List<ExceptionHandlerExtensionPoint> exceptionHandlers, TestExtensionContext testExtensionContext) throws Throwable {
        ExceptionHandlerExtensionPoint exceptionHandler = exceptionHandlers.remove(0);
        exceptionHandler.handleException(testExtensionContext, throwable);
    }

    private void rethrowExceptionIfThereIsNoHandlerLeft(Throwable throwable, List<ExceptionHandlerExtensionPoint> exceptionHandlers) {
        if (exceptionHandlers.isEmpty()) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)throwable);
        }
    }

    private List<ExceptionHandlerExtensionPoint> collectExceptionHandlerExtensionPoints(ExtensionRegistry extensionRegistry) {
        return extensionRegistry.stream(ExceptionHandlerExtensionPoint.class, ExtensionRegistry.ApplicationOrder.FORWARD).map(RegisteredExtensionPoint::getExtensionPoint).collect(Collectors.toList());
    }

    private void invokeAfterEachExtensionPoints(ExtensionRegistry extensionRegistry, TestExtensionContext testExtensionContext, ThrowableCollector throwableCollector) throws Exception {
        extensionRegistry.stream(AfterEachExtensionPoint.class, ExtensionRegistry.ApplicationOrder.BACKWARD).forEach(registeredExtensionPoint -> throwableCollector.execute(() -> ((AfterEachExtensionPoint)registeredExtensionPoint.getExtensionPoint()).afterEach(testExtensionContext)));
    }
}

