/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.api;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.gen5.api.Executable;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ExceptionUtils;
import org.junit.gen5.commons.util.StringUtils;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

@API(value=API.Usage.Maintained)
public final class Assertions {
    private Assertions() {
    }

    public static void fail(String message) {
        throw new AssertionFailedError(message);
    }

    public static void fail(Supplier<String> messageSupplier) {
        Assertions.fail(Assertions.nullSafeGet(messageSupplier));
    }

    public static void assertTrue(boolean condition) {
        Assertions.assertTrue(() -> condition, () -> null);
    }

    public static void assertTrue(boolean condition, Supplier<String> messageSupplier) {
        Assertions.assertTrue(() -> condition, messageSupplier);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier) {
        Assertions.assertTrue(booleanSupplier, () -> null);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, String message) {
        Assertions.assertTrue(booleanSupplier, () -> message);
    }

    public static void assertTrue(boolean condition, String message) {
        Assertions.assertTrue(() -> condition, () -> message);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        if (!booleanSupplier.getAsBoolean()) {
            Assertions.fail(messageSupplier);
        }
    }

    public static void assertFalse(boolean condition) {
        Assertions.assertFalse(() -> condition, () -> null);
    }

    public static void assertFalse(boolean condition, String message) {
        Assertions.assertFalse(() -> condition, () -> message);
    }

    public static void assertFalse(boolean condition, Supplier<String> messageSupplier) {
        Assertions.assertFalse(() -> condition, messageSupplier);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier) {
        Assertions.assertFalse(booleanSupplier, () -> null);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, String message) {
        Assertions.assertFalse(booleanSupplier, () -> message);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        if (booleanSupplier.getAsBoolean()) {
            Assertions.fail(messageSupplier);
        }
    }

    public static void assertNull(Object actual) {
        Assertions.assertNull(actual, () -> null);
    }

    public static void assertNull(Object actual, String message) {
        Assertions.assertNull(actual, () -> message);
    }

    public static void assertNull(Object actual, Supplier<String> messageSupplier) {
        if (actual != null) {
            Assertions.failNotNull(actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotNull(Object actual) {
        Assertions.assertNotNull(actual, () -> null);
    }

    public static void assertNotNull(Object actual, String message) {
        Assertions.assertNotNull(actual, () -> message);
    }

    public static void assertNotNull(Object actual, Supplier<String> messageSupplier) {
        if (actual == null) {
            Assertions.failNull(Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(Object expected, Object actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(Object expected, Object actual, Supplier<String> messageSupplier) {
        if (!Objects.equals(expected, actual)) {
            Assertions.failNotEqual(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        Assertions.assertNotEquals(unexpected, actual, () -> null);
    }

    public static void assertNotEquals(Object unexpected, Object actual, String message) {
        Assertions.assertNotEquals(unexpected, actual, () -> message);
    }

    public static void assertNotEquals(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        if (Objects.equals(unexpected, actual)) {
            Assertions.failEqual(actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertSame(Object expected, Object actual) {
        Assertions.assertSame(expected, actual, () -> null);
    }

    public static void assertSame(Object expected, Object actual, String message) {
        Assertions.assertSame(expected, actual, () -> message);
    }

    public static void assertSame(Object expected, Object actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            Assertions.failNotSame(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        Assertions.assertNotSame(unexpected, actual, () -> null);
    }

    public static void assertNotSame(Object unexpected, Object actual, String message) {
        Assertions.assertNotSame(unexpected, actual, () -> message);
    }

    public static void assertNotSame(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        if (unexpected == actual) {
            Assertions.failSame(actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    @API(value=API.Usage.Experimental)
    public static void assertAll(Executable ... asserts) throws MultipleFailuresError {
        Assertions.assertAll(null, asserts);
    }

    @API(value=API.Usage.Experimental)
    public static void assertAll(String heading, Executable ... asserts) throws MultipleFailuresError {
        MultipleFailuresError multipleFailuresError = new MultipleFailuresError(heading);
        for (Executable executable : asserts) {
            try {
                executable.execute();
            }
            catch (AssertionError assertionError) {
                multipleFailuresError.addFailure(assertionError);
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        }
        if (multipleFailuresError.hasFailures()) {
            throw multipleFailuresError;
        }
    }

    public static void assertThrows(Class<? extends Throwable> expected, Executable executable) {
        Assertions.expectThrows(expected, executable);
    }

    public static <T extends Throwable> T expectThrows(Class<T> expectedType, Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable actualException) {
            if (expectedType.isInstance(actualException)) {
                return (T)actualException;
            }
            String message = Assertions.format(expectedType.getName(), actualException.getClass().getName(), "Unexpected exception type thrown");
            throw new AssertionFailedError(message, actualException);
        }
        throw new AssertionFailedError(String.format("Expected %s to be thrown, but nothing was thrown.", expectedType.getName()));
    }

    private static void failEqual(Object actual, String message) {
        Assertions.fail(Assertions.buildPrefix(message) + "expected: not equal but was: <" + actual + ">");
    }

    private static void failNull(String message) {
        Assertions.fail(Assertions.buildPrefix(message) + "expected: not <null>");
    }

    private static void failNotNull(Object actual, String message) {
        Assertions.fail(Assertions.buildPrefix(message) + "expected: <null> but was: <" + actual + ">");
    }

    private static void failSame(Object actual, String message) {
        Assertions.fail(Assertions.buildPrefix(message) + "expected: not same but was: <" + actual + ">");
    }

    private static void failNotSame(Object expected, Object actual, String message) {
        Assertions.fail(Assertions.format(expected, actual, message));
    }

    private static void failNotEqual(Object expected, Object actual, String message) {
        Assertions.fail(Assertions.format(expected, actual, message));
    }

    private static String format(Object expected, Object actual, String message) {
        String actualString;
        String prefix = Assertions.buildPrefix(message);
        String expectedString = String.valueOf(expected);
        if (expectedString.equals(actualString = String.valueOf(actual))) {
            return prefix + "expected: " + Assertions.formatClassAndValue(expected, expectedString) + " but was: " + Assertions.formatClassAndValue(actual, actualString);
        }
        return prefix + "expected: <" + expectedString + "> but was: <" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        String hash = value == null ? "" : "@" + Integer.toHexString(System.identityHashCode(value));
        return className + hash + "<" + valueString + ">";
    }

    private static String buildPrefix(String message) {
        return StringUtils.isNotBlank((String)message) ? message + " ==> " : "";
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

