/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.support.hierarchical;

import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.engine.support.hierarchical.BlacklistedExceptions;
import org.opentest4j.TestAbortedException;

class SingleTestExecutor {
    SingleTestExecutor() {
    }

    TestExecutionResult executeSafely(Executable executable) {
        try {
            executable.execute();
            return TestExecutionResult.successful();
        }
        catch (TestAbortedException e) {
            return TestExecutionResult.aborted(e);
        }
        catch (Throwable t) {
            BlacklistedExceptions.rethrowIfBlacklisted(t);
            return TestExecutionResult.failed(t);
        }
    }

    static interface Executable {
        public void execute() throws Throwable;
    }
}

