/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.support.hierarchical;

import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.ExecutionRequest;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.engine.support.hierarchical.BlacklistedExceptions;
import org.junit.gen5.engine.support.hierarchical.Container;
import org.junit.gen5.engine.support.hierarchical.EngineExecutionContext;
import org.junit.gen5.engine.support.hierarchical.Leaf;
import org.junit.gen5.engine.support.hierarchical.Node;
import org.junit.gen5.engine.support.hierarchical.SingleTestExecutor;

class HierarchicalTestExecutor<C extends EngineExecutionContext> {
    private final SingleTestExecutor singleTestExecutor = new SingleTestExecutor();
    private final MixinAdapter<C> adapter = new MixinAdapter();
    private final TestDescriptor rootTestDescriptor;
    private final EngineExecutionListener listener;
    private final C rootContext;

    HierarchicalTestExecutor(ExecutionRequest request, C rootContext) {
        this.rootTestDescriptor = request.getRootTestDescriptor();
        this.listener = request.getEngineExecutionListener();
        this.rootContext = rootContext;
    }

    void execute() {
        this.executeAll(this.rootTestDescriptor, this.rootContext);
    }

    private void executeAll(TestDescriptor testDescriptor, C parentContext) {
        C preparedContext;
        try {
            preparedContext = this.adapter.asNode(testDescriptor).prepare(parentContext);
            Node.SkipResult skipResult = this.adapter.asNode(testDescriptor).shouldBeSkipped(preparedContext);
            if (skipResult.isSkipped()) {
                this.listener.executionSkipped(testDescriptor, skipResult.getReason().orElse("<unknown>"));
                return;
            }
        }
        catch (Throwable throwable) {
            BlacklistedExceptions.rethrowIfBlacklisted(throwable);
            this.listener.executionStarted(testDescriptor);
            this.listener.executionFinished(testDescriptor, TestExecutionResult.failed(throwable));
            return;
        }
        this.listener.executionStarted(testDescriptor);
        TestExecutionResult result = this.singleTestExecutor.executeSafely(() -> {
            EngineExecutionContext context = this.adapter.asContainer(testDescriptor).beforeAll((EngineExecutionContext)preparedContext);
            context = this.adapter.asLeaf(testDescriptor).execute(context);
            for (TestDescriptor testDescriptor2 : testDescriptor.getChildren()) {
                this.executeAll(testDescriptor2, context);
            }
            context = this.adapter.asContainer(testDescriptor).afterAll(context);
        });
        this.listener.executionFinished(testDescriptor, result);
    }

    private static class MixinAdapter<C extends EngineExecutionContext> {
        private static final Container nullContainer = new Container(){};
        private static final Leaf nullLeaf = context -> context;
        private static final Node nullNode = new Node(){};

        private MixinAdapter() {
        }

        Container<C> asContainer(TestDescriptor testDescriptor) {
            return (Container)(testDescriptor instanceof Container ? testDescriptor : nullContainer);
        }

        Leaf<C> asLeaf(TestDescriptor testDescriptor) {
            return (Leaf)(testDescriptor instanceof Leaf ? testDescriptor : nullLeaf);
        }

        Node<C> asNode(TestDescriptor testDescriptor) {
            return (Node)(testDescriptor instanceof Node ? testDescriptor : nullNode);
        }
    }
}

