/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.support.descriptor;

import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.StringUtils;
import org.junit.gen5.engine.TestSource;

@API(value=API.Usage.Experimental)
public class JavaSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final Class<?> javaClass;
    private final String javaMethodName;
    private final Class<?>[] javaMethodParameterTypes;

    public JavaSource(Class<?> clazz) {
        this.javaClass = clazz;
        this.javaMethodName = null;
        this.javaMethodParameterTypes = null;
    }

    public JavaSource(Method method) {
        this.javaClass = method.getDeclaringClass();
        this.javaMethodName = method.getName();
        this.javaMethodParameterTypes = method.getParameterTypes();
    }

    @Override
    public boolean isJavaClass() {
        return this.javaClass != null && this.javaMethodName == null;
    }

    @Override
    public boolean isJavaMethod() {
        return this.javaMethodName != null;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isFilePosition() {
        return false;
    }

    public Optional<Class<?>> getJavaClass() {
        return Optional.ofNullable(this.javaClass);
    }

    public Optional<String> getJavaMethodName() {
        return Optional.ofNullable(this.javaMethodName);
    }

    public Optional<Class<?>[]> getJavaMethodParameterTypes() {
        return Optional.ofNullable(this.javaMethodParameterTypes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.getJavaClass().ifPresent(clazz -> builder.append(clazz.getName()));
        this.getJavaMethodName().ifPresent(method -> builder.append('#').append((String)method));
        this.getJavaMethodParameterTypes().ifPresent(parameterTypes -> builder.append('(').append(StringUtils.nullSafeToString((Class[])parameterTypes)).append(')'));
        return builder.toString();
    }
}

