/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.reporting;

import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ExceptionUtils;
import org.junit.gen5.commons.util.Preconditions;

@API(value=API.Usage.Experimental)
public class ReportEntry {
    private final LocalDateTime creationTimestamp = LocalDateTime.now();
    private final Map<String, String> values;

    public static ReportEntry from(Map<String, String> values) {
        return new ReportEntry(values);
    }

    public static ReportEntry from(String key, String value) {
        return new ReportEntry(key, value);
    }

    private ReportEntry(Map<String, String> values) {
        Preconditions.notNull(values, (String)"values to be reported must not be null");
        this.values = values;
    }

    private ReportEntry(String key, String value) {
        this(Collections.singletonMap(key, value));
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public LocalDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String toString() {
        return this.values.toString() + " @ " + this.creationTimestamp;
    }

    public void appendDescription(Appendable appendable, String entryTitle) {
        try {
            appendable.append(MessageFormat.format("Report Entry{0} (creation timestamp: {1})\n", entryTitle, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.getCreationTimestamp())));
            for (Map.Entry<String, String> entry : this.getValues().entrySet()) {
                appendable.append(MessageFormat.format("\t- {0}: {1}\n", entry.getKey(), entry.getValue()));
            }
        }
        catch (IOException cannotHappen) {
            ExceptionUtils.throwAsUncheckedException((Throwable)cannotHappen);
        }
    }
}

