/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.value.convert.bool;

import java.util.Map;
import org.jtwig.value.Undefined;
import org.jtwig.value.convert.Converter;

public class BooleanConverter
implements Converter<Boolean> {
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    @Override
    public Converter.Result<Boolean> convert(Object object) {
        if (object == null) {
            return Converter.Result.defined(false);
        }
        if (object == Undefined.UNDEFINED) {
            return Converter.Result.defined(false);
        }
        if (object instanceof Boolean) {
            return Converter.Result.defined((Boolean)object);
        }
        if (object instanceof String) {
            if (TRUE.equals(object)) {
                return Converter.Result.defined(true);
            }
            if (FALSE.equals(object)) {
                return Converter.Result.defined(false);
            }
        }
        if (object.getClass().isArray()) {
            return Converter.Result.defined(((Object[])object).length > 0);
        }
        if (object instanceof Iterable) {
            return Converter.Result.defined(((Iterable)object).iterator().hasNext());
        }
        if (object instanceof Map) {
            return Converter.Result.defined(((Map)object).size() > 0);
        }
        if (object instanceof Number) {
            return Converter.Result.defined(((Number)object).intValue() != 0);
        }
        return Converter.Result.undefined();
    }
}

