/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.node.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.jtwig.model.expression.VariableExpression;
import org.jtwig.model.tree.ForLoopNode;
import org.jtwig.render.RenderRequest;
import org.jtwig.render.context.StackedContext;
import org.jtwig.render.expression.CalculateExpressionService;
import org.jtwig.render.node.RenderNodeService;
import org.jtwig.render.node.renderer.NodeRender;
import org.jtwig.renderable.Renderable;
import org.jtwig.renderable.impl.CompositeRenderable;
import org.jtwig.util.LoopCursor;
import org.jtwig.value.WrappedCollection;
import org.jtwig.value.context.StaticVariableValueContext;
import org.jtwig.value.context.ValueContext;
import org.jtwig.value.convert.Converter;

public class ForLoopNodeRender
implements NodeRender<ForLoopNode> {
    public static final String LOOP = "loop";

    @Override
    public Renderable render(RenderRequest request, ForLoopNode node) {
        ArrayList<Renderable> renderables = new ArrayList<Renderable>();
        Converter<WrappedCollection> collectionConverter = request.getEnvironment().getValueEnvironment().getCollectionConverter();
        RenderNodeService renderNodeService = request.getEnvironment().getRenderEnvironment().getRenderNodeService();
        CalculateExpressionService calculateExpressionService = request.getEnvironment().getRenderEnvironment().getCalculateExpressionService();
        Object collectionJtwigValue = calculateExpressionService.calculate(request, node.getExpression());
        WrappedCollection valueCollection = collectionConverter.convert(collectionJtwigValue).or(WrappedCollection.singleton(collectionJtwigValue));
        if (valueCollection == null) {
            valueCollection = WrappedCollection.empty();
        }
        StackedContext<ValueContext> valueContext = request.getRenderContext().getValueContext();
        ValueContext parentContext = valueContext.getCurrent();
        LoopCursor loopCursor = new LoopCursor(parentContext, valueCollection);
        StaticVariableValueContext newValueContext = new StaticVariableValueContext(parentContext, LOOP, loopCursor);
        valueContext.start(newValueContext);
        for (Map.Entry<String, Object> item : valueCollection) {
            newValueContext.with(node.getVariableExpression().getIdentifier(), item.getValue());
            if (node.getKeyVariableExpression().isPresent()) {
                newValueContext.with(((VariableExpression)node.getKeyVariableExpression().get()).getIdentifier(), item.getKey());
            }
            renderables.add(renderNodeService.render(request, node.getContent()));
            loopCursor.step();
        }
        valueContext.end();
        return new CompositeRenderable(renderables);
    }
}

