/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.expression.calculator.operation.binary.calculators.selection;

import com.google.common.base.Optional;
import org.jtwig.exceptions.CalculationException;
import org.jtwig.reflection.model.Value;
import org.jtwig.render.expression.calculator.operation.binary.calculators.BinaryOperationCalculator;
import org.jtwig.render.expression.calculator.operation.binary.calculators.selection.PropertyAndArgumentsCalculator;
import org.jtwig.render.expression.calculator.operation.binary.calculators.selection.ResolveSelectionPropertyCalculator;
import org.jtwig.util.ErrorMessageFormatter;
import org.jtwig.value.Undefined;

public class SelectionOperationCalculator
implements BinaryOperationCalculator {
    private final PropertyAndArgumentsCalculator propertyAndArgumentsCalculator;
    private final ResolveSelectionPropertyCalculator resolveSelectionPropertyCalculator;

    public SelectionOperationCalculator(PropertyAndArgumentsCalculator propertyAndArgumentsCalculator, ResolveSelectionPropertyCalculator resolveSelectionPropertyCalculator) {
        this.propertyAndArgumentsCalculator = propertyAndArgumentsCalculator;
        this.resolveSelectionPropertyCalculator = resolveSelectionPropertyCalculator;
    }

    @Override
    public Object calculate(BinaryOperationCalculator.Request request) {
        Object leftValue = request.getEnvironment().getRenderEnvironment().getCalculateExpressionService().calculate(request, request.getLeftOperand());
        PropertyAndArgumentsCalculator.Response response = this.propertyAndArgumentsCalculator.calculate(request, request.getPosition(), request.getRightOperand());
        Optional<Value> optional = this.resolveSelectionPropertyCalculator.calculate(request, request.getPosition(), response.getPropertyName(), response.getArguments(), leftValue);
        if (optional.isPresent()) {
            return ((Value)optional.get()).getValue();
        }
        if (request.getEnvironment().getRenderEnvironment().getStrictMode()) {
            throw new CalculationException(ErrorMessageFormatter.errorMessage(request.getPosition(), String.format("Impossible to access an attribute '%s' on '%s'", response.getPropertyName(), leftValue)));
        }
        return Undefined.UNDEFINED;
    }
}

