/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.expression.calculator.operation.binary.calculators.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jtwig.exceptions.CalculationException;
import org.jtwig.model.expression.Expression;
import org.jtwig.model.expression.FunctionExpression;
import org.jtwig.model.expression.VariableExpression;
import org.jtwig.model.position.Position;
import org.jtwig.render.RenderRequest;
import org.jtwig.render.expression.CalculateExpressionService;
import org.jtwig.util.ErrorMessageFormatter;

public class PropertyAndArgumentsCalculator {
    public Response calculate(RenderRequest request, Position position, Expression expression) {
        if (VariableExpression.class.isAssignableFrom(expression.getClass())) {
            return new Response(((VariableExpression)expression).getIdentifier(), Collections.emptyList());
        }
        if (FunctionExpression.class.isAssignableFrom(expression.getClass())) {
            return new Response(((FunctionExpression)expression).getFunctionIdentifier(), this.calculateArguments(request, (FunctionExpression)expression));
        }
        throw new CalculationException(ErrorMessageFormatter.errorMessage(position, String.format("Expecting variable or function, but got %s", expression.getClass().getSimpleName())));
    }

    private List<Object> calculateArguments(RenderRequest request, FunctionExpression expression) {
        CalculateExpressionService calculateExpressionService = request.getEnvironment().getRenderEnvironment().getCalculateExpressionService();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Expression argument : expression.getArguments()) {
            result.add(calculateExpressionService.calculate(request, argument));
        }
        return result;
    }

    public static class Response {
        private final String propertyName;
        private final List<Object> arguments;

        public Response(String propertyName, List<Object> arguments) {
            this.propertyName = propertyName;
            this.arguments = arguments;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public List<Object> getArguments() {
            return this.arguments;
        }
    }
}

