/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.context.model;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import org.jtwig.model.tree.BlockNode;
import org.jtwig.render.context.model.BlockDefinition;
import org.jtwig.resource.reference.ResourceReference;

public class BlockContext {
    private final Map<String, BlockDefinition> blocks;

    public static BlockContext newContext() {
        return new BlockContext(new HashMap<String, BlockDefinition>());
    }

    public BlockContext(Map<String, BlockDefinition> blocks) {
        this.blocks = blocks;
    }

    public Optional<BlockDefinition> get(String identifier) {
        return Optional.fromNullable((Object)this.blocks.get(identifier));
    }

    public void add(BlockNode node, ResourceReference source) {
        if (!this.blocks.containsKey(node.getIdentifier())) {
            this.blocks.put(node.getIdentifier(), new BlockDefinition(node.getContent(), source));
        }
    }
}

